/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.SiteData;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.GlobalXSiteAdminOperations;
import org.infinispan.xsite.XSiteAdminOperations;

public class SiteStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(SiteStatement.class, Log.class);
    private final SiteData siteData;
    private final List<Option> options;

    public SiteStatement(List<Option> options, SiteData siteData) {
        this.options = options;
        this.siteData = siteData;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        if (this.options.isEmpty()) {
            return EmptyResult.RESULT;
        }
        Options option = this.options.get(0).toEnum(Options.class);
        if (SiteStatement.isGlobalOption(option)) {
            return this.executeContainerOperation(option, session);
        }
        return this.executeCacheOperation(option, session);
    }

    private Result executeCacheOperation(Options option, Session session) throws StatementException {
        Cache cache = session.getCache(this.siteData != null ? this.siteData.getCacheName() : null);
        String siteName = this.siteData != null ? this.siteData.getSiteName() : null;
        XSiteAdminOperations xsiteAdmin = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
        SiteStatement.requireXSiteAdmin(xsiteAdmin, cache.getName());
        switch (option) {
            case STATUS: {
                return new StringResult(siteName == null ? xsiteAdmin.status() : xsiteAdmin.siteStatus(siteName));
            }
            case ONLINE: {
                SiteStatement.requireSiteName(siteName);
                return new StringResult(xsiteAdmin.bringSiteOnline(siteName));
            }
            case OFFLINE: {
                SiteStatement.requireSiteName(siteName);
                return new StringResult(xsiteAdmin.takeSiteOffline(siteName));
            }
            case PUSH: {
                SiteStatement.requireSiteName(siteName);
                return new StringResult(xsiteAdmin.pushState(siteName));
            }
            case CANCELPUSH: {
                SiteStatement.requireSiteName(siteName);
                return new StringResult(xsiteAdmin.cancelPushState(siteName));
            }
            case CANCELRECEIVE: {
                SiteStatement.requireSiteName(siteName);
                return new StringResult(xsiteAdmin.cancelReceiveState(siteName));
            }
            case PUSHSTATUS: {
                return new StringResult(SiteStatement.prettyPrintMap(xsiteAdmin.getPushStateStatus()));
            }
            case CLEARPUSHSTATUS: {
                return new StringResult(xsiteAdmin.clearPushStateStatus());
            }
            case SENDINGSITE: {
                return new StringResult(xsiteAdmin.getSendingSiteName());
            }
        }
        return EmptyResult.RESULT;
    }

    private Result executeContainerOperation(Options option, Session session) throws StatementException {
        EmbeddedCacheManager cacheManager = session.getCacheManager();
        GlobalXSiteAdminOperations xSiteAdmin = (GlobalXSiteAdminOperations)cacheManager.getGlobalComponentRegistry().getComponent(GlobalXSiteAdminOperations.class);
        String siteName = this.siteData != null ? this.siteData.getSiteName() : null;
        SiteStatement.requireSiteName(siteName);
        switch (option) {
            case OFFLINEALL: {
                return new StringResult(xSiteAdmin.takeSiteOffline(siteName));
            }
            case ONLINEALL: {
                return new StringResult(xSiteAdmin.bringSiteOnline(siteName));
            }
            case PUSHALL: {
                return new StringResult(xSiteAdmin.pushState(siteName));
            }
            case CANCELPUSHALL: {
                return new StringResult(xSiteAdmin.cancelPushState(siteName));
            }
        }
        return EmptyResult.RESULT;
    }

    private static boolean isGlobalOption(Options option) {
        switch (option) {
            case OFFLINEALL: 
            case ONLINEALL: 
            case PUSHALL: 
            case CANCELPUSHALL: {
                return true;
            }
        }
        return false;
    }

    private static void requireXSiteAdmin(XSiteAdminOperations xSiteAdminOperations, String cacheName) throws StatementException {
        if (xSiteAdminOperations == null) {
            throw log.noBackupsForCache(cacheName);
        }
    }

    private static void requireSiteName(String siteName) throws StatementException {
        if (siteName == null) {
            throw log.siteNameNotSpecified();
        }
    }

    private static String prettyPrintMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            builder.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    static enum Options {
        OFFLINE,
        ONLINE,
        STATUS,
        PUSH,
        CANCELPUSH,
        CANCELRECEIVE,
        PUSHSTATUS,
        CLEARPUSHSTATUS,
        SENDINGSITE,
        ONLINEALL,
        OFFLINEALL,
        PUSHALL,
        CANCELPUSHALL;

    }
}

