/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="cli.interpreter.HotRodEncodingTest", groups={"functional"})
@CleanupAfterMethod
public class HotRodEncodingTest
extends SingleCacheManagerTest {
    private static final String REGULAR_CACHE = "default";
    private static final String COMPAT_CACHE = "compat";
    HotRodServer hotrodServer;
    int port;
    Interpreter interpreter;
    private RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() {
        org.infinispan.configuration.cache.ConfigurationBuilder c = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
        c.jmxStatistics().enable();
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createServerModeCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)c);
        org.infinispan.configuration.cache.ConfigurationBuilder compatBuilder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        compatBuilder.compatibility().enable();
        org.infinispan.configuration.cache.ConfigurationBuilder defaultBuilder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        cacheManager.defineConfiguration(COMPAT_CACHE, compatBuilder.build());
        cacheManager.defineConfiguration(REGULAR_CACHE, defaultBuilder.build());
        return cacheManager;
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.port = this.hotrodServer.getPort();
        this.remoteCacheManager = new RemoteCacheManager(new ConfigurationBuilder().addServer().host("localhost").port(this.port).build());
        this.remoteCacheManager.start();
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        this.interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.remoteCacheManager);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrodServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testHotRodCodec() throws Exception {
        this.testHotRodCodecWithCache(REGULAR_CACHE);
    }

    public void testHotRodCodecWithCompat() throws Exception {
        this.testHotRodCodecWithCache(COMPAT_CACHE);
    }

    public void testHotRodEncoding() throws Exception {
        this.testHotRodEncodingWithCache(REGULAR_CACHE);
    }

    public void testHotRodEncodingWithCompat() throws Exception {
        this.testHotRodEncodingWithCache(COMPAT_CACHE);
    }

    private void testHotRodCodecWithCache(String cacheName) throws Exception {
        Cache cache = this.cacheManager.getCache(cacheName);
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName);
        remoteCache.put((Object)"k1", (Object)"v1");
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        byte[] k1 = marshaller.objectToByteBuffer((Object)"k1");
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)k1));
        String sessionId = this.interpreter.createSessionId(cacheName);
        Map response = this.interpreter.execute(sessionId, "get --codec=hotrod k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.assertInterpreter(this.interpreter.execute(sessionId, "remove --codec=hotrod k1;"));
        String v1 = (String)remoteCache.get((Object)"k1");
        AssertJUnit.assertNull((Object)v1);
        this.assertInterpreter(this.interpreter.execute(sessionId, "put --codec=hotrod k2 v2;"));
        String v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
        this.assertInterpreter(this.interpreter.execute(sessionId, "evict --codec=hotrod k2;"));
        v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertNull((Object)v2);
    }

    private void testHotRodEncodingWithCache(String cacheName) throws Exception {
        Cache cache = this.cacheManager.getCache(cacheName);
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName);
        remoteCache.put((Object)"k1", (Object)"v1");
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        byte[] k1 = marshaller.objectToByteBuffer((Object)"k1");
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)k1));
        String sessionId = this.interpreter.createSessionId(cacheName);
        this.interpreter.execute(sessionId, "encoding hotrod;");
        Map response = this.interpreter.execute(sessionId, "get k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.assertInterpreter(this.interpreter.execute(sessionId, "put k2 v2;"));
        String v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
    }

    private void assertInterpreter(Map<String, String> response) {
        AssertJUnit.assertNull((Object)response.get(ResultKeys.ERROR.toString()));
    }
}

