/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.codec;

import java.nio.charset.StandardCharsets;
import org.infinispan.cli.interpreter.codec.AbstractCodec;
import org.infinispan.cli.interpreter.codec.CodecException;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.util.logging.LogFactory;

public class MemcachedCodec
extends AbstractCodec {
    private static final Log log = (Log)LogFactory.getLog(MemcachedCodec.class, Log.class);

    public MemcachedCodec() {
        try {
            Class.forName("org.infinispan.server.memcached.MemcachedServer");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return "memcached";
    }

    @Override
    public void setWhiteList(ClassWhiteList whiteList) {
    }

    @Override
    public Object encodeKey(Object key) {
        if (key == null) {
            return null;
        }
        return key.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Object encodeValue(Object value) throws CodecException {
        if (value != null) {
            if (value instanceof String) {
                return ((String)value).getBytes(StandardCharsets.UTF_8);
            }
            if (value instanceof byte[]) {
                return value;
            }
            throw log.valueEncodingFailed(value.getClass().getName(), this.getName());
        }
        return null;
    }

    @Override
    public Object decodeKey(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof byte[]) {
            return new String((byte[])key, StandardCharsets.UTF_8);
        }
        return key.toString();
    }

    @Override
    public Object decodeValue(Object value) {
        if (value != null) {
            return new String((byte[])value, StandardCharsets.UTF_8);
        }
        return null;
    }
}

