/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import org.infinispan.Cache;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.SecurityActions;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfoStatement
implements Statement {
    final String cacheName;

    public InfoStatement(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        if (this.cacheName != null) {
            return this.cacheInfo(session);
        }
        return this.cacheManagerInfo(session);
    }

    private Result cacheManagerInfo(Session session) {
        EmbeddedCacheManager cacheManager = session.getCacheManager();
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(cacheManager);
        return new StringResult(globalConfiguration.toString());
    }

    private Result cacheInfo(Session session) {
        Cache cache = session.getCache(this.cacheName);
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        return new StringResult(cacheConfiguration.toString());
    }
}

