/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.upgrade;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.upgrade.SourceMigrator;

public class CLInterfaceSourceMigrator
implements SourceMigrator {
    private static final String KNOWN_KEY = "___MigrationManager_CLI_KnownKeys___";
    private final Cache<String, Set<Object>> cache;

    public CLInterfaceSourceMigrator(Cache<?, ?> cache) {
        this.cache = cache;
    }

    public void recordKnownGlobalKeyset() {
        try {
            HashSet keys;
            CacheMode cm = this.cache.getCacheConfiguration().clustering().cacheMode();
            if (cm.isReplicated() || !cm.isClustered()) {
                keys = new HashSet(this.cache.keySet());
            } else {
                DefaultExecutorService des = new DefaultExecutorService(this.cache);
                List keysets = des.submitEverywhere((Callable)((Object)new GlobalKeysetTask(this.cache)));
                HashSet combinedKeyset = new HashSet();
                for (Future keyset : keysets) {
                    combinedKeyset.addAll((Collection)keyset.get());
                }
                keys = combinedKeyset;
            }
            keys.remove(KNOWN_KEY);
            this.cache.put((Object)KNOWN_KEY, keys);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new CacheException("Unable to record all known keys", (Throwable)e);
        }
    }

    public String getCacheName() {
        return this.cache.getName();
    }

    static class GlobalKeysetTask
    implements DistributedCallable<Object, Object, Set<Object>> {
        final Cache<?, ?> cache;

        GlobalKeysetTask(Cache<?, ?> cache) {
            this.cache = cache;
        }

        public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
        }

        public Set<Object> call() throws Exception {
            return new HashSet<Object>(this.cache.keySet());
        }
    }
}

