/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.IspnQLLexer;
import org.infinispan.cli.interpreter.IspnQLParser;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.PutStatement;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli-server.IspnQLTest")
public class IspnQLTest {
    Session session;
    Cache cache;

    @BeforeMethod
    public void setup() {
        this.session = (Session)Mockito.mock(Session.class);
        this.cache = (Cache)Mockito.mock(Cache.class);
        Mockito.when((Object)this.session.getCache()).thenReturn((Object)this.cache);
    }

    public void testStringLiterals() throws IOException, RecognitionException {
        IspnQLParser parser = this.createParser("\"DoubleQuotedString\"");
        IspnQLParser.literal_return literal = parser.literal();
    }

    public void testPutStatement() throws IOException, RecognitionException {
        IspnQLParser parser = this.createParser("put 'a' 'b';");
        parser.statements();
        PutStatement s = (PutStatement)parser.statements.get(0);
        s.execute(this.session);
        ((Cache)Mockito.verify((Object)this.cache)).put((Object)"a", (Object)"b");
    }

    public void testPutStatementUnquoted() throws IOException, RecognitionException {
        IspnQLParser parser = this.createParser("put a b;");
        parser.statements();
        PutStatement s = (PutStatement)parser.statements.get(0);
        s.execute(this.session);
        ((Cache)Mockito.verify((Object)this.cache)).put((Object)"a", (Object)"b");
    }

    public void testPutStatementExpiration() throws IOException, RecognitionException {
        IspnQLParser parser = this.createParser("put 'a' 'b' expires 1h;");
        parser.statements();
        PutStatement s = (PutStatement)parser.statements.get(0);
        s.execute(this.session);
        ((Cache)Mockito.verify((Object)this.cache)).put((Object)"a", (Object)"b", 3600000L, TimeUnit.MILLISECONDS);
    }

    public void testPutStatementExpirationIdle() throws IOException, RecognitionException {
        IspnQLParser parser = this.createParser("put 'a' 'b' expires 1h maxidle 30m;");
        parser.statements();
        PutStatement s = (PutStatement)parser.statements.get(0);
        s.execute(this.session);
        ((Cache)Mockito.verify((Object)this.cache)).put((Object)"a", (Object)"b", 3600000L, TimeUnit.MILLISECONDS, 1800000L, TimeUnit.MILLISECONDS);
    }

    public void testPutCacheQualifier() throws IOException, RecognitionException {
        IspnQLParser parser = this.createParser("put 'myCache'.'a' 'b';");
        parser.statements();
        PutStatement s = (PutStatement)parser.statements.get(0);
        Mockito.when((Object)this.session.getCache("myCache")).thenReturn((Object)this.cache);
        s.execute(this.session);
        ((Session)Mockito.verify((Object)this.session)).getCache("myCache");
        ((Cache)Mockito.verify((Object)this.cache)).put((Object)"a", (Object)"b");
    }

    public void testPutCacheQualifierUnquoted() throws IOException, RecognitionException {
        IspnQLParser parser = this.createParser("put myCache.a b;");
        parser.statements();
        PutStatement s = (PutStatement)parser.statements.get(0);
        Mockito.when((Object)this.session.getCache("myCache")).thenReturn((Object)this.cache);
        s.execute(this.session);
        ((Session)Mockito.verify((Object)this.session)).getCache("myCache");
        ((Cache)Mockito.verify((Object)this.cache)).put((Object)"a", (Object)"b");
    }

    private IspnQLParser createParser(String testString) throws IOException {
        ANTLRStringStream stream = new ANTLRStringStream(testString);
        IspnQLLexer lexer = new IspnQLLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        IspnQLParser parser = new IspnQLParser((TokenStream)tokens);
        return parser;
    }
}

