/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.util.logging.LogFactory;

public class LifecycleCallbacks
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleCallbacks.class, Log.class);
    private ObjectName interpreterObjName;

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
        MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
        String groupName = this.getGroupName(globalCfg);
        String jmxDomain = globalCfg.globalJmxStatistics().domain();
        Interpreter interpreter = new Interpreter();
        gcr.registerComponent((Object)interpreter, Interpreter.class);
        ManageableComponentMetadata meta = ComponentMetadataRepo.findComponentMetadata(Interpreter.class).toManageableComponentMetadata();
        try {
            ResourceDMBean mbean = new ResourceDMBean((Object)interpreter, meta);
            this.interpreterObjName = new ObjectName(String.format("%s:%s,component=Interpreter", jmxDomain, groupName));
            JmxUtil.registerMBean((ResourceDMBean)mbean, (ObjectName)this.interpreterObjName, (MBeanServer)mbeanServer);
        }
        catch (Exception e) {
            this.interpreterObjName = null;
            log.jmxRegistrationFailed();
        }
    }

    private String getGroupName(GlobalConfiguration globalCfg) {
        return "type=CacheManager," + ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(globalCfg.globalJmxStatistics().cacheManagerName());
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        if (this.interpreterObjName != null) {
            GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
            MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
            try {
                JmxUtil.unregisterMBean((ObjectName)this.interpreterObjName, (MBeanServer)mbeanServer);
            }
            catch (Exception e) {
                log.jmxUnregistrationFailed();
            }
        }
    }
}

