/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.MyClass;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli-server.InterpreterTest")
public class InterpreterTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.jmxStatistics().enable().dataContainer().invocationBatching().enable();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)c);
    }

    public void testSimple() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId();
        interpreter.execute(sessionId, "put 'a' 'b'; get 'a';");
        interpreter.execute(sessionId, "put 'c' {\"org.infinispan.cli.interpreter.MyClass\":{\"i\":5,\"x\":null,\"b\":true}};");
        Object o = this.cache.get((Object)"c");
        assert (o != null);
        assert (o instanceof MyClass);
        assert (((MyClass)o).i == 5);
        assert (((MyClass)o).b);
        interpreter.execute(sessionId, "put 'f' 0.5;");
        Double f = (Double)this.cache.get((Object)"f");
        assert (f == 0.5);
    }

    public void testCacheQualifier() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId();
        Cache otherCache = this.cacheManager.getCache("otherCache");
        interpreter.execute(sessionId, "put 'a' 'a'; put 'otherCache'.'b' 'b'; cache 'otherCache'; put 'c' 'c';");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        Object b = otherCache.get((Object)"b");
        assert (b.equals("b"));
        Object c = otherCache.get((Object)"c");
        assert (c.equals("c"));
    }

    public void testBatching() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId();
        interpreter.execute(sessionId, "start; put 'a' 'a'; put 'b' 'b'; end;");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        Object b = this.cache.get((Object)"b");
        assert (b.equals("b"));
    }

    public void testTx() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId();
        interpreter.execute(sessionId, "begin; put 'a' 'a'; commit;");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        interpreter.execute(sessionId, "begin; put 'b' 'b'; rollback;");
        assert (!this.cache.containsKey((Object)"b"));
    }

    public void testDangling() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId();
        interpreter.execute(sessionId, "begin; put 'a' 'a';");
        assert (this.cache.getAdvancedCache().getTransactionManager().getTransaction() == null);
        assert (!this.cache.containsKey((Object)"a"));
        interpreter.execute(sessionId, "start; put 'a' 'a';");
        assert (this.cache.getAdvancedCache().getBatchContainer().getBatchTransaction() == null);
        assert (!this.cache.containsKey((Object)"a"));
    }

    public void testRemove() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId();
        interpreter.execute(sessionId, "put 'a' 'a';");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        interpreter.execute(sessionId, "remove 'a';");
        assert (!this.cache.containsKey((Object)"a"));
        interpreter.execute(sessionId, "put 'b' 'b';");
        Object b = this.cache.get((Object)"b");
        assert (b.equals("b"));
        interpreter.execute(sessionId, "remove 'b' 'c';");
        assert (this.cache.containsKey((Object)"b"));
    }

    public void testReplace() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId();
        interpreter.execute(sessionId, "put 'a' 'a';");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        interpreter.execute(sessionId, "replace 'a' 'b';");
        a = this.cache.get((Object)"a");
        assert (a.equals("b"));
        interpreter.execute(sessionId, "replace 'a' 'b' 'c';");
        a = this.cache.get((Object)"a");
        assert (a.equals("c"));
        interpreter.execute(sessionId, "replace 'a' 'b' 'd';");
        a = this.cache.get((Object)"a");
        assert (a.equals("c"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidSession() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = "123";
        interpreter.execute(sessionId, "put 'a' 'a';");
    }
}

