/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.infinispan.cli.interpreter.IspnQLLexer;
import org.infinispan.cli.interpreter.IspnQLParser;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.session.SessionImpl;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.SysPropertyActions;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="Interpreter", description="Interpreter component which executes CLI operations")
public class Interpreter {
    private static final Log log = (Log)LogFactory.getLog(Interpreter.class, Log.class);
    private static final long DEFAULT_SESSION_REAPER_WAKEUP_INTERVAL = 60000L;
    private static final long DEFAULT_SESSION_TIMEOUT = 60000L;
    private EmbeddedCacheManager cacheManager;
    private ScheduledExecutorService executor;
    private long sessionReaperWakeupInterval = 60000L;
    private long sessionTimeout = 60000L;
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private ScheduledFuture<?> sessionReaperTask;

    @Inject
    public void initialize(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Interpreter");
            }
        });
    }

    @Start
    public void start() {
        this.sessionReaperTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), this.sessionReaperWakeupInterval, this.sessionReaperWakeupInterval, TimeUnit.MILLISECONDS);
    }

    @Stop
    public void stop() {
        if (this.sessionReaperTask != null) {
            this.sessionReaperTask.cancel(true);
        }
    }

    @ManagedOperation(description="Creates a new interpreter session")
    public String createSessionId() {
        String sessionId = UUID.randomUUID().toString();
        this.sessions.put(sessionId, new SessionImpl(this.cacheManager, sessionId));
        return sessionId;
    }

    public long getSessionReaperWakeupInterval() {
        return this.sessionReaperWakeupInterval;
    }

    public void setSessionReaperWakeupInterval(long sessionReaperWakeupInterval) {
        this.sessionReaperWakeupInterval = sessionReaperWakeupInterval;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    void expireSessions() {
        long timeBoundary = System.nanoTime() - this.sessionTimeout * 1000000L;
        Iterator<Session> i = this.sessions.values().iterator();
        while (i.hasNext()) {
            Session session = i.next();
            if (session.getTimestamp() >= timeBoundary) continue;
            i.remove();
            if (!log.isDebugEnabled()) continue;
            log.debugf("Removed expired interpreter session %s", session.getId());
        }
    }

    @ManagedOperation(description="Parses and executes IspnQL statements")
    public String execute(String sessionId, String s) throws Exception {
        if (sessionId == null || !this.sessions.containsKey(sessionId)) {
            throw new IllegalArgumentException("Invalid session ID");
        }
        ANTLRStringStream stream = new ANTLRStringStream(s);
        IspnQLLexer lexer = new IspnQLLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        IspnQLParser parser = new IspnQLParser((TokenStream)tokens);
        ClassLoader oldCL = SysPropertyActions.setThreadContextClassLoader((ClassLoader)this.cacheManager.getCacheManagerConfiguration().classLoader());
        Session session = null;
        try {
            parser.statements();
            session = this.sessions.get(sessionId);
            StringBuilder output = new StringBuilder();
            for (Statement stmt : parser.statements) {
                Result result = stmt.execute(session);
                if (result == EmptyResult.RESULT) continue;
                output.append(result.getResult());
            }
            String i$ = output.length() == 0 ? null : output.toString();
            return i$;
        }
        catch (Exception e) {
            log.interpreterError(e);
            Exception exception = new Exception(e.getMessage());
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        finally {
            if (session != null) {
                session.reset();
            }
            SysPropertyActions.setThreadContextClassLoader((ClassLoader)oldCL);
        }
    }

    @ManagedAttribute(description="Retrieves a list of caches for the cache manager")
    public String[] getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>(this.cacheManager.getCacheNames());
        cacheNames.add("___defaultcache");
        return cacheNames.toArray(new String[0]);
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            Interpreter.this.expireSessions();
        }
    }
}

