/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.AbstractTransactionStatement;

public class BeginTransactionStatement
extends AbstractTransactionStatement {
    public BeginTransactionStatement(String cacheName) {
        super(cacheName);
    }

    @Override
    public Result execute(Session session) throws StatementException {
        TransactionManager tm = this.getTransactionManager(session);
        if (tm == null) {
            throw new StatementException("Cannot retrieve a transaction manager for the cache");
        }
        try {
            tm.begin();
            return EmptyResult.RESULT;
        }
        catch (NotSupportedException e) {
            throw new StatementException("The TransactionManager does not support nested transactions");
        }
        catch (SystemException e) {
            throw new StatementException("Unexpected error while starting transaction: " + e.getMessage());
        }
    }
}

