/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import org.infinispan.Cache;
import org.infinispan.cli.interpreter.result.JsonResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Statement;

public class GetStatement
implements Statement {
    final KeyData keyData;

    public GetStatement(KeyData key) {
        this.keyData = key;
    }

    @Override
    public Result execute(Session session) {
        Cache cache = session.getCache(this.keyData.getCacheName());
        Object value = cache.get(this.keyData.key);
        if (value == null) {
            return new StringResult("null");
        }
        if (value instanceof String) {
            return new StringResult((String)value);
        }
        if (value.getClass().isPrimitive()) {
            return new StringResult(value.toString());
        }
        return new JsonResult(value);
    }
}

