/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.ExpirationData;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Statement;

public class PutStatement
implements Statement {
    final KeyData keyData;
    final Object value;
    final Long expires;
    final Long maxIdle;

    public PutStatement(KeyData key, Object value, ExpirationData exp) {
        this.keyData = key;
        this.value = value;
        if (exp != null) {
            this.expires = exp.expires;
            this.maxIdle = exp.maxIdle;
        } else {
            this.expires = null;
            this.maxIdle = null;
        }
    }

    @Override
    public Result execute(Session session) {
        Cache cache = session.getCache(this.keyData.getCacheName());
        if (this.expires == null) {
            cache.put(this.keyData.getKey(), this.value);
        } else if (this.maxIdle == null) {
            cache.put(this.keyData.getKey(), this.value, this.expires.longValue(), TimeUnit.MILLISECONDS);
        } else {
            cache.put(this.keyData.getKey(), this.value, this.expires.longValue(), TimeUnit.MILLISECONDS, this.maxIdle.longValue(), TimeUnit.MILLISECONDS);
        }
        return EmptyResult.RESULT;
    }
}

