// $ANTLR 3.4 org/infinispan/cli/interpreter/IspnQL.g 2012-11-19 01:05:09

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.infinispan.cli.interpreter;

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectMapper.DefaultTyping;

import org.infinispan.cli.interpreter.session.*;
import org.infinispan.cli.interpreter.statement.*;
import static org.infinispan.cli.interpreter.utils.ParserSupport.*;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class IspnQLParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABORT", "AlphaChar", "AlphaNumChar", "BEGIN", "CACHE", "CLEAR", "COMMIT", "CREATE", "CharacterEscapeSequence", "Comment", "DOUBLELITERAL", "DecimalDigit", "DoubleQuotedStringCharacter", "DoubleSuffix", "END", "EOL", "EVICT", "EXPIRES", "EscapeCharacter", "EscapeSequence", "Exponent", "FALSE", "FLOATLITERAL", "FloatSuffix", "GET", "HexDigit", "HexEscapeSequence", "HexPrefix", "INFO", "INTLITERAL", "IntegerNumber", "LIKE", "LOCATE", "LONGLITERAL", "LineComment", "LongSuffix", "MAXIDLE", "NULL", "NonEscapeCharacter", "NonIntegerNumber", "PUT", "PUTIFABSENT", "REMOVE", "REPLACE", "ROLLBACK", "START", "STATS", "STRINGLITERAL", "SingleEscapeCharacter", "SingleQuotedStringCharacter", "TIMELITERAL", "TRUE", "TimeSuffix", "UPGRADE", "UUIDLITERAL", "UnicodeEscapeSequence", "UnquotedStringCharacter", "UnquotedStringStart", "VERSION", "WhiteSpace", "','", "'--'", "'.'", "':'", "';'", "'['", "']'", "'{'", "'}'"
    };

    public static final int EOF=-1;
    public static final int T__64=64;
    public static final int T__65=65;
    public static final int T__66=66;
    public static final int T__67=67;
    public static final int T__68=68;
    public static final int T__69=69;
    public static final int T__70=70;
    public static final int T__71=71;
    public static final int T__72=72;
    public static final int ABORT=4;
    public static final int AlphaChar=5;
    public static final int AlphaNumChar=6;
    public static final int BEGIN=7;
    public static final int CACHE=8;
    public static final int CLEAR=9;
    public static final int COMMIT=10;
    public static final int CREATE=11;
    public static final int CharacterEscapeSequence=12;
    public static final int Comment=13;
    public static final int DOUBLELITERAL=14;
    public static final int DecimalDigit=15;
    public static final int DoubleQuotedStringCharacter=16;
    public static final int DoubleSuffix=17;
    public static final int END=18;
    public static final int EOL=19;
    public static final int EVICT=20;
    public static final int EXPIRES=21;
    public static final int EscapeCharacter=22;
    public static final int EscapeSequence=23;
    public static final int Exponent=24;
    public static final int FALSE=25;
    public static final int FLOATLITERAL=26;
    public static final int FloatSuffix=27;
    public static final int GET=28;
    public static final int HexDigit=29;
    public static final int HexEscapeSequence=30;
    public static final int HexPrefix=31;
    public static final int INFO=32;
    public static final int INTLITERAL=33;
    public static final int IntegerNumber=34;
    public static final int LIKE=35;
    public static final int LOCATE=36;
    public static final int LONGLITERAL=37;
    public static final int LineComment=38;
    public static final int LongSuffix=39;
    public static final int MAXIDLE=40;
    public static final int NULL=41;
    public static final int NonEscapeCharacter=42;
    public static final int NonIntegerNumber=43;
    public static final int PUT=44;
    public static final int PUTIFABSENT=45;
    public static final int REMOVE=46;
    public static final int REPLACE=47;
    public static final int ROLLBACK=48;
    public static final int START=49;
    public static final int STATS=50;
    public static final int STRINGLITERAL=51;
    public static final int SingleEscapeCharacter=52;
    public static final int SingleQuotedStringCharacter=53;
    public static final int TIMELITERAL=54;
    public static final int TRUE=55;
    public static final int TimeSuffix=56;
    public static final int UPGRADE=57;
    public static final int UUIDLITERAL=58;
    public static final int UnicodeEscapeSequence=59;
    public static final int UnquotedStringCharacter=60;
    public static final int UnquotedStringStart=61;
    public static final int VERSION=62;
    public static final int WhiteSpace=63;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public IspnQLParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public IspnQLParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return IspnQLParser.tokenNames; }
    public String getGrammarFileName() { return "org/infinispan/cli/interpreter/IspnQL.g"; }


       private List<String> parserErrors = new ArrayList<String>();
       protected List<Statement> statements = new ArrayList<Statement>();
       private ObjectMapper jsonMapper = new ObjectMapper().enableDefaultTyping(DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);

       public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
         parserErrors.add(getErrorHeader(e)+" "+getErrorMessage(e, tokenNames));
       }

       public List<String> getParserErrors() {
         return parserErrors;
       }


    public static class statements_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statements"
    // org/infinispan/cli/interpreter/IspnQL.g:106:1: statements : ( statement ( EOL )* )* EOF ;
    public final IspnQLParser.statements_return statements() throws RecognitionException {
        IspnQLParser.statements_return retval = new IspnQLParser.statements_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EOL2=null;
        Token EOF3=null;
        IspnQLParser.statement_return statement1 =null;


        Object EOL2_tree=null;
        Object EOF3_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:107:4: ( ( statement ( EOL )* )* EOF )
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )* EOF
            {
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case ABORT:
                case BEGIN:
                case CACHE:
                case CLEAR:
                case COMMIT:
                case CREATE:
                case END:
                case EVICT:
                case GET:
                case INFO:
                case LOCATE:
                case PUT:
                case PUTIFABSENT:
                case REMOVE:
                case REPLACE:
                case ROLLBACK:
                case START:
                case STATS:
                case UPGRADE:
                case VERSION:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:107:7: statement ( EOL )*
            	    {
            	    pushFollow(FOLLOW_statement_in_statements72);
            	    statement1=statement();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statement1.getTree());

            	     statements.add((statement1!=null?statement1.stmt:null)); 

            	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: ( EOL )*
            	    loop1:
            	    do {
            	        int alt1=2;
            	        switch ( input.LA(1) ) {
            	        case EOL:
            	            {
            	            alt1=1;
            	            }
            	            break;

            	        }

            	        switch (alt1) {
            	    	case 1 :
            	    	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: EOL
            	    	    {
            	    	    EOL2=(Token)match(input,EOL,FOLLOW_EOL_in_statements76); 
            	    	    EOL2_tree = 
            	    	    (Object)adaptor.create(EOL2)
            	    	    ;
            	    	    adaptor.addChild(root_0, EOL2_tree);


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop1;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            EOF3=(Token)match(input,EOF,FOLLOW_EOF_in_statements81); 
            EOF3_tree = 
            (Object)adaptor.create(EOF3)
            ;
            adaptor.addChild(root_0, EOF3_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statements"


    public static class statement_return extends ParserRuleReturnScope {
        public Statement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/infinispan/cli/interpreter/IspnQL.g:110:1: statement returns [Statement stmt] : ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | createStatement | endBatchStatement | evictStatement | getStatement | infoStatement | locateStatement | putIfAbsentStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement );
    public final IspnQLParser.statement_return statement() throws RecognitionException {
        IspnQLParser.statement_return retval = new IspnQLParser.statement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnQLParser.abortBatchStatement_return abortBatchStatement4 =null;

        IspnQLParser.beginTransactionStatement_return beginTransactionStatement5 =null;

        IspnQLParser.cacheStatement_return cacheStatement6 =null;

        IspnQLParser.clearStatement_return clearStatement7 =null;

        IspnQLParser.commitTransactionStatement_return commitTransactionStatement8 =null;

        IspnQLParser.createStatement_return createStatement9 =null;

        IspnQLParser.endBatchStatement_return endBatchStatement10 =null;

        IspnQLParser.evictStatement_return evictStatement11 =null;

        IspnQLParser.getStatement_return getStatement12 =null;

        IspnQLParser.infoStatement_return infoStatement13 =null;

        IspnQLParser.locateStatement_return locateStatement14 =null;

        IspnQLParser.putIfAbsentStatement_return putIfAbsentStatement15 =null;

        IspnQLParser.putStatement_return putStatement16 =null;

        IspnQLParser.removeStatement_return removeStatement17 =null;

        IspnQLParser.replaceStatement_return replaceStatement18 =null;

        IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement19 =null;

        IspnQLParser.startBatchStatement_return startBatchStatement20 =null;

        IspnQLParser.statsStatement_return statsStatement21 =null;

        IspnQLParser.upgradeStatement_return upgradeStatement22 =null;

        IspnQLParser.versionStatement_return versionStatement23 =null;



        try {
            // org/infinispan/cli/interpreter/IspnQL.g:111:4: ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | createStatement | endBatchStatement | evictStatement | getStatement | infoStatement | locateStatement | putIfAbsentStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement )
            int alt3=20;
            switch ( input.LA(1) ) {
            case ABORT:
                {
                alt3=1;
                }
                break;
            case BEGIN:
                {
                alt3=2;
                }
                break;
            case CACHE:
                {
                alt3=3;
                }
                break;
            case CLEAR:
                {
                alt3=4;
                }
                break;
            case COMMIT:
                {
                alt3=5;
                }
                break;
            case CREATE:
                {
                alt3=6;
                }
                break;
            case END:
                {
                alt3=7;
                }
                break;
            case EVICT:
                {
                alt3=8;
                }
                break;
            case GET:
                {
                alt3=9;
                }
                break;
            case INFO:
                {
                alt3=10;
                }
                break;
            case LOCATE:
                {
                alt3=11;
                }
                break;
            case PUTIFABSENT:
                {
                alt3=12;
                }
                break;
            case PUT:
                {
                alt3=13;
                }
                break;
            case REMOVE:
                {
                alt3=14;
                }
                break;
            case REPLACE:
                {
                alt3=15;
                }
                break;
            case ROLLBACK:
                {
                alt3=16;
                }
                break;
            case START:
                {
                alt3=17;
                }
                break;
            case STATS:
                {
                alt3=18;
                }
                break;
            case UPGRADE:
                {
                alt3=19;
                }
                break;
            case VERSION:
                {
                alt3=20;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:111:6: abortBatchStatement
                    {
                    pushFollow(FOLLOW_abortBatchStatement_in_statement100);
                    abortBatchStatement4=abortBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, abortBatchStatement4.getTree());

                     retval.stmt = (abortBatchStatement4!=null?abortBatchStatement4.stmt:null); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:112:6: beginTransactionStatement
                    {
                    pushFollow(FOLLOW_beginTransactionStatement_in_statement109);
                    beginTransactionStatement5=beginTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, beginTransactionStatement5.getTree());

                     retval.stmt = (beginTransactionStatement5!=null?beginTransactionStatement5.stmt:null); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:113:6: cacheStatement
                    {
                    pushFollow(FOLLOW_cacheStatement_in_statement118);
                    cacheStatement6=cacheStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, cacheStatement6.getTree());

                     retval.stmt = (cacheStatement6!=null?cacheStatement6.stmt:null); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:114:6: clearStatement
                    {
                    pushFollow(FOLLOW_clearStatement_in_statement127);
                    clearStatement7=clearStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, clearStatement7.getTree());

                     retval.stmt = (clearStatement7!=null?clearStatement7.stmt:null); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:115:6: commitTransactionStatement
                    {
                    pushFollow(FOLLOW_commitTransactionStatement_in_statement136);
                    commitTransactionStatement8=commitTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, commitTransactionStatement8.getTree());

                     retval.stmt = (commitTransactionStatement8!=null?commitTransactionStatement8.stmt:null); 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:116:6: createStatement
                    {
                    pushFollow(FOLLOW_createStatement_in_statement145);
                    createStatement9=createStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createStatement9.getTree());

                     retval.stmt = (createStatement9!=null?createStatement9.stmt:null); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:117:6: endBatchStatement
                    {
                    pushFollow(FOLLOW_endBatchStatement_in_statement154);
                    endBatchStatement10=endBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, endBatchStatement10.getTree());

                     retval.stmt = (endBatchStatement10!=null?endBatchStatement10.stmt:null); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:118:6: evictStatement
                    {
                    pushFollow(FOLLOW_evictStatement_in_statement163);
                    evictStatement11=evictStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, evictStatement11.getTree());

                     retval.stmt = (evictStatement11!=null?evictStatement11.stmt:null); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:119:6: getStatement
                    {
                    pushFollow(FOLLOW_getStatement_in_statement172);
                    getStatement12=getStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, getStatement12.getTree());

                     retval.stmt = (getStatement12!=null?getStatement12.stmt:null); 

                    }
                    break;
                case 10 :
                    // org/infinispan/cli/interpreter/IspnQL.g:120:6: infoStatement
                    {
                    pushFollow(FOLLOW_infoStatement_in_statement181);
                    infoStatement13=infoStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, infoStatement13.getTree());

                     retval.stmt = (infoStatement13!=null?infoStatement13.stmt:null); 

                    }
                    break;
                case 11 :
                    // org/infinispan/cli/interpreter/IspnQL.g:121:6: locateStatement
                    {
                    pushFollow(FOLLOW_locateStatement_in_statement190);
                    locateStatement14=locateStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, locateStatement14.getTree());

                     retval.stmt = (locateStatement14!=null?locateStatement14.stmt:null); 

                    }
                    break;
                case 12 :
                    // org/infinispan/cli/interpreter/IspnQL.g:122:6: putIfAbsentStatement
                    {
                    pushFollow(FOLLOW_putIfAbsentStatement_in_statement199);
                    putIfAbsentStatement15=putIfAbsentStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putIfAbsentStatement15.getTree());

                     retval.stmt = (putIfAbsentStatement15!=null?putIfAbsentStatement15.stmt:null); 

                    }
                    break;
                case 13 :
                    // org/infinispan/cli/interpreter/IspnQL.g:123:6: putStatement
                    {
                    pushFollow(FOLLOW_putStatement_in_statement208);
                    putStatement16=putStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putStatement16.getTree());

                     retval.stmt = (putStatement16!=null?putStatement16.stmt:null); 

                    }
                    break;
                case 14 :
                    // org/infinispan/cli/interpreter/IspnQL.g:124:6: removeStatement
                    {
                    pushFollow(FOLLOW_removeStatement_in_statement217);
                    removeStatement17=removeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, removeStatement17.getTree());

                     retval.stmt = (removeStatement17!=null?removeStatement17.stmt:null); 

                    }
                    break;
                case 15 :
                    // org/infinispan/cli/interpreter/IspnQL.g:125:6: replaceStatement
                    {
                    pushFollow(FOLLOW_replaceStatement_in_statement226);
                    replaceStatement18=replaceStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, replaceStatement18.getTree());

                     retval.stmt = (replaceStatement18!=null?replaceStatement18.stmt:null); 

                    }
                    break;
                case 16 :
                    // org/infinispan/cli/interpreter/IspnQL.g:126:6: rollbackTransactionStatement
                    {
                    pushFollow(FOLLOW_rollbackTransactionStatement_in_statement235);
                    rollbackTransactionStatement19=rollbackTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, rollbackTransactionStatement19.getTree());

                     retval.stmt = (rollbackTransactionStatement19!=null?rollbackTransactionStatement19.stmt:null); 

                    }
                    break;
                case 17 :
                    // org/infinispan/cli/interpreter/IspnQL.g:127:6: startBatchStatement
                    {
                    pushFollow(FOLLOW_startBatchStatement_in_statement244);
                    startBatchStatement20=startBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, startBatchStatement20.getTree());

                     retval.stmt = (startBatchStatement20!=null?startBatchStatement20.stmt:null); 

                    }
                    break;
                case 18 :
                    // org/infinispan/cli/interpreter/IspnQL.g:128:6: statsStatement
                    {
                    pushFollow(FOLLOW_statsStatement_in_statement253);
                    statsStatement21=statsStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, statsStatement21.getTree());

                     retval.stmt = (statsStatement21!=null?statsStatement21.stmt:null); 

                    }
                    break;
                case 19 :
                    // org/infinispan/cli/interpreter/IspnQL.g:129:6: upgradeStatement
                    {
                    pushFollow(FOLLOW_upgradeStatement_in_statement262);
                    upgradeStatement22=upgradeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, upgradeStatement22.getTree());

                     retval.stmt = (upgradeStatement22!=null?upgradeStatement22.stmt:null); 

                    }
                    break;
                case 20 :
                    // org/infinispan/cli/interpreter/IspnQL.g:130:6: versionStatement
                    {
                    pushFollow(FOLLOW_versionStatement_in_statement271);
                    versionStatement23=versionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, versionStatement23.getTree());

                     retval.stmt = (versionStatement23!=null?versionStatement23.stmt:null); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class abortBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "abortBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:134:1: abortBatchStatement returns [EndBatchStatement stmt] : ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.abortBatchStatement_return abortBatchStatement() throws RecognitionException {
        IspnQLParser.abortBatchStatement_return retval = new IspnQLParser.abortBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ABORT24=null;
        Token set25=null;

        Object cacheName_tree=null;
        Object ABORT24_tree=null;
        Object set25_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:135:4: ( ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:135:6: ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ABORT24=(Token)match(input,ABORT,FOLLOW_ABORT_in_abortBatchStatement293); 
            ABORT24_tree = 
            (Object)adaptor.create(ABORT24)
            ;
            adaptor.addChild(root_0, ABORT24_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:135:12: (cacheName= STRINGLITERAL )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:135:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_abortBatchStatement300); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set25=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), false); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "abortBatchStatement"


    public static class beginTransactionStatement_return extends ParserRuleReturnScope {
        public BeginTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "beginTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:138:1: beginTransactionStatement returns [BeginTransactionStatement stmt] : BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.beginTransactionStatement_return beginTransactionStatement() throws RecognitionException {
        IspnQLParser.beginTransactionStatement_return retval = new IspnQLParser.beginTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token BEGIN26=null;
        Token set27=null;

        Object cacheName_tree=null;
        Object BEGIN26_tree=null;
        Object set27_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:139:4: ( BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:139:6: BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            BEGIN26=(Token)match(input,BEGIN,FOLLOW_BEGIN_in_beginTransactionStatement332); 
            BEGIN26_tree = 
            (Object)adaptor.create(BEGIN26)
            ;
            adaptor.addChild(root_0, BEGIN26_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:139:12: (cacheName= STRINGLITERAL )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:139:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_beginTransactionStatement339); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set27=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new BeginTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "beginTransactionStatement"


    public static class cacheStatement_return extends ParserRuleReturnScope {
        public CacheStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cacheStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:142:1: cacheStatement returns [CacheStatement stmt] : CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.cacheStatement_return cacheStatement() throws RecognitionException {
        IspnQLParser.cacheStatement_return retval = new IspnQLParser.cacheStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CACHE28=null;
        Token set29=null;

        Object cacheName_tree=null;
        Object CACHE28_tree=null;
        Object set29_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:143:4: ( CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:143:6: CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CACHE28=(Token)match(input,CACHE,FOLLOW_CACHE_in_cacheStatement371); 
            CACHE28_tree = 
            (Object)adaptor.create(CACHE28)
            ;
            adaptor.addChild(root_0, CACHE28_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:143:12: (cacheName= STRINGLITERAL )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:143:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_cacheStatement378); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set29=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CacheStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cacheStatement"


    public static class clearStatement_return extends ParserRuleReturnScope {
        public ClearStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "clearStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:146:1: clearStatement returns [ClearStatement stmt] : CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.clearStatement_return clearStatement() throws RecognitionException {
        IspnQLParser.clearStatement_return retval = new IspnQLParser.clearStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CLEAR30=null;
        Token set31=null;

        Object cacheName_tree=null;
        Object CLEAR30_tree=null;
        Object set31_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:147:4: ( CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:147:6: CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CLEAR30=(Token)match(input,CLEAR,FOLLOW_CLEAR_in_clearStatement410); 
            CLEAR30_tree = 
            (Object)adaptor.create(CLEAR30)
            ;
            adaptor.addChild(root_0, CLEAR30_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:147:12: (cacheName= STRINGLITERAL )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:147:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_clearStatement417); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set31=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new ClearStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "clearStatement"


    public static class commitTransactionStatement_return extends ParserRuleReturnScope {
        public CommitTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "commitTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:150:1: commitTransactionStatement returns [CommitTransactionStatement stmt] : COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.commitTransactionStatement_return commitTransactionStatement() throws RecognitionException {
        IspnQLParser.commitTransactionStatement_return retval = new IspnQLParser.commitTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token COMMIT32=null;
        Token set33=null;

        Object cacheName_tree=null;
        Object COMMIT32_tree=null;
        Object set33_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:151:4: ( COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:151:6: COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            COMMIT32=(Token)match(input,COMMIT,FOLLOW_COMMIT_in_commitTransactionStatement448); 
            COMMIT32_tree = 
            (Object)adaptor.create(COMMIT32)
            ;
            adaptor.addChild(root_0, COMMIT32_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:151:13: (cacheName= STRINGLITERAL )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:151:14: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_commitTransactionStatement455); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set33=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CommitTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "commitTransactionStatement"


    public static class createStatement_return extends ParserRuleReturnScope {
        public CreateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:154:1: createStatement returns [CreateStatement stmt] : CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.createStatement_return createStatement() throws RecognitionException {
        IspnQLParser.createStatement_return retval = new IspnQLParser.createStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token baseCacheName=null;
        Token CREATE34=null;
        Token LIKE35=null;
        Token set36=null;

        Object cacheName_tree=null;
        Object baseCacheName_tree=null;
        Object CREATE34_tree=null;
        Object LIKE35_tree=null;
        Object set36_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:155:4: ( CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:155:6: CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CREATE34=(Token)match(input,CREATE,FOLLOW_CREATE_in_createStatement487); 
            CREATE34_tree = 
            (Object)adaptor.create(CREATE34)
            ;
            adaptor.addChild(root_0, CREATE34_tree);


            cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement493); 
            cacheName_tree = 
            (Object)adaptor.create(cacheName)
            ;
            adaptor.addChild(root_0, cacheName_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:155:39: ( LIKE baseCacheName= STRINGLITERAL )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case LIKE:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:155:40: LIKE baseCacheName= STRINGLITERAL
                    {
                    LIKE35=(Token)match(input,LIKE,FOLLOW_LIKE_in_createStatement496); 
                    LIKE35_tree = 
                    (Object)adaptor.create(LIKE35)
                    ;
                    adaptor.addChild(root_0, LIKE35_tree);


                    baseCacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement502); 
                    baseCacheName_tree = 
                    (Object)adaptor.create(baseCacheName)
                    ;
                    adaptor.addChild(root_0, baseCacheName_tree);


                    }
                    break;

            }


            set36=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CreateStatement(unquote((cacheName!=null?cacheName.getText():null)), unquote((baseCacheName!=null?baseCacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createStatement"


    public static class endBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "endBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:158:1: endBatchStatement returns [EndBatchStatement stmt] : END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.endBatchStatement_return endBatchStatement() throws RecognitionException {
        IspnQLParser.endBatchStatement_return retval = new IspnQLParser.endBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token END37=null;
        Token set38=null;

        Object cacheName_tree=null;
        Object END37_tree=null;
        Object set38_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:159:4: ( END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:159:6: END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            END37=(Token)match(input,END,FOLLOW_END_in_endBatchStatement537); 
            END37_tree = 
            (Object)adaptor.create(END37)
            ;
            adaptor.addChild(root_0, END37_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:159:10: (cacheName= STRINGLITERAL )?
            int alt10=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt10=1;
                    }
                    break;
            }

            switch (alt10) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:159:11: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_endBatchStatement544); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set38=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), true); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "endBatchStatement"


    public static class evictStatement_return extends ParserRuleReturnScope {
        public EvictStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "evictStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:162:1: evictStatement returns [EvictStatement stmt] : EVICT key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.evictStatement_return evictStatement() throws RecognitionException {
        IspnQLParser.evictStatement_return retval = new IspnQLParser.evictStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EVICT39=null;
        Token set40=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object EVICT39_tree=null;
        Object set40_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:163:4: ( EVICT key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:163:6: EVICT key= keyIdentifier ( EOL | ';' ) !
            {
            EVICT39=(Token)match(input,EVICT,FOLLOW_EVICT_in_evictStatement576); 
            EVICT39_tree = 
            (Object)adaptor.create(EVICT39)
            ;
            adaptor.addChild(root_0, EVICT39_tree);


            pushFollow(FOLLOW_keyIdentifier_in_evictStatement582);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set40=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EvictStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "evictStatement"


    public static class getStatement_return extends ParserRuleReturnScope {
        public GetStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "getStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:166:1: getStatement returns [GetStatement stmt] : GET key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.getStatement_return getStatement() throws RecognitionException {
        IspnQLParser.getStatement_return retval = new IspnQLParser.getStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token GET41=null;
        Token set42=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object GET41_tree=null;
        Object set42_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:167:4: ( GET key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:167:6: GET key= keyIdentifier ( EOL | ';' ) !
            {
            GET41=(Token)match(input,GET,FOLLOW_GET_in_getStatement612); 
            GET41_tree = 
            (Object)adaptor.create(GET41)
            ;
            adaptor.addChild(root_0, GET41_tree);


            pushFollow(FOLLOW_keyIdentifier_in_getStatement618);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set42=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new GetStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "getStatement"


    public static class infoStatement_return extends ParserRuleReturnScope {
        public InfoStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "infoStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:170:1: infoStatement returns [InfoStatement stmt] : INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.infoStatement_return infoStatement() throws RecognitionException {
        IspnQLParser.infoStatement_return retval = new IspnQLParser.infoStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token INFO43=null;
        Token set44=null;

        Object cacheName_tree=null;
        Object INFO43_tree=null;
        Object set44_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:171:4: ( INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:171:6: INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            INFO43=(Token)match(input,INFO,FOLLOW_INFO_in_infoStatement648); 
            INFO43_tree = 
            (Object)adaptor.create(INFO43)
            ;
            adaptor.addChild(root_0, INFO43_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:171:11: (cacheName= STRINGLITERAL )?
            int alt11=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt11=1;
                    }
                    break;
            }

            switch (alt11) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:171:12: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_infoStatement655); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set44=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new InfoStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "infoStatement"


    public static class locateStatement_return extends ParserRuleReturnScope {
        public LocateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:174:1: locateStatement returns [LocateStatement stmt] : LOCATE key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.locateStatement_return locateStatement() throws RecognitionException {
        IspnQLParser.locateStatement_return retval = new IspnQLParser.locateStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LOCATE45=null;
        Token set46=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object LOCATE45_tree=null;
        Object set46_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:175:4: ( LOCATE key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:175:6: LOCATE key= keyIdentifier ( EOL | ';' ) !
            {
            LOCATE45=(Token)match(input,LOCATE,FOLLOW_LOCATE_in_locateStatement687); 
            LOCATE45_tree = 
            (Object)adaptor.create(LOCATE45)
            ;
            adaptor.addChild(root_0, LOCATE45_tree);


            pushFollow(FOLLOW_keyIdentifier_in_locateStatement693);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set46=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new LocateStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateStatement"


    public static class putIfAbsentStatement_return extends ParserRuleReturnScope {
        public PutIfAbsentStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putIfAbsentStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:178:1: putIfAbsentStatement returns [PutIfAbsentStatement stmt] : PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.putIfAbsentStatement_return putIfAbsentStatement() throws RecognitionException {
        IspnQLParser.putIfAbsentStatement_return retval = new IspnQLParser.putIfAbsentStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUTIFABSENT47=null;
        Token set48=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;

        IspnQLParser.expirationClause_return exp =null;


        Object PUTIFABSENT47_tree=null;
        Object set48_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:179:4: ( PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:179:6: PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUTIFABSENT47=(Token)match(input,PUTIFABSENT,FOLLOW_PUTIFABSENT_in_putIfAbsentStatement723); 
            PUTIFABSENT47_tree = 
            (Object)adaptor.create(PUTIFABSENT47)
            ;
            adaptor.addChild(root_0, PUTIFABSENT47_tree);


            pushFollow(FOLLOW_keyIdentifier_in_putIfAbsentStatement729);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putIfAbsentStatement735);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:179:54: (exp= expirationClause )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:179:55: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putIfAbsentStatement742);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set48=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutIfAbsentStatement((key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putIfAbsentStatement"


    public static class putStatement_return extends ParserRuleReturnScope {
        public PutStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:182:1: putStatement returns [PutStatement stmt] : PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.putStatement_return putStatement() throws RecognitionException {
        IspnQLParser.putStatement_return retval = new IspnQLParser.putStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUT49=null;
        Token set50=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;

        IspnQLParser.expirationClause_return exp =null;


        Object PUT49_tree=null;
        Object set50_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:183:4: ( PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:183:6: PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUT49=(Token)match(input,PUT,FOLLOW_PUT_in_putStatement774); 
            PUT49_tree = 
            (Object)adaptor.create(PUT49)
            ;
            adaptor.addChild(root_0, PUT49_tree);


            pushFollow(FOLLOW_keyIdentifier_in_putStatement780);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putStatement786);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:183:46: (exp= expirationClause )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:183:47: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putStatement793);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set50=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutStatement((key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putStatement"


    public static class removeStatement_return extends ParserRuleReturnScope {
        public RemoveStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "removeStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:186:1: removeStatement returns [RemoveStatement stmt] : REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !;
    public final IspnQLParser.removeStatement_return removeStatement() throws RecognitionException {
        IspnQLParser.removeStatement_return retval = new IspnQLParser.removeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REMOVE51=null;
        Token set52=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;


        Object REMOVE51_tree=null;
        Object set52_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:187:4: ( REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:187:6: REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !
            {
            REMOVE51=(Token)match(input,REMOVE,FOLLOW_REMOVE_in_removeStatement825); 
            REMOVE51_tree = 
            (Object)adaptor.create(REMOVE51)
            ;
            adaptor.addChild(root_0, REMOVE51_tree);


            pushFollow(FOLLOW_keyIdentifier_in_removeStatement831);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:187:33: (value= literal )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 71:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:187:34: value= literal
                    {
                    pushFollow(FOLLOW_literal_in_removeStatement838);
                    value=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value.getTree());

                    }
                    break;

            }


            set52=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RemoveStatement((key!=null?key.key:null), (value!=null?value.o:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "removeStatement"


    public static class replaceStatement_return extends ParserRuleReturnScope {
        public ReplaceStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "replaceStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:190:1: replaceStatement returns [ReplaceStatement stmt] : REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.replaceStatement_return replaceStatement() throws RecognitionException {
        IspnQLParser.replaceStatement_return retval = new IspnQLParser.replaceStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REPLACE53=null;
        Token set54=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value1 =null;

        IspnQLParser.literal_return value2 =null;

        IspnQLParser.expirationClause_return exp =null;


        Object REPLACE53_tree=null;
        Object set54_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:191:4: ( REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:191:6: REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !
            {
            REPLACE53=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_replaceStatement870); 
            REPLACE53_tree = 
            (Object)adaptor.create(REPLACE53)
            ;
            adaptor.addChild(root_0, REPLACE53_tree);


            pushFollow(FOLLOW_keyIdentifier_in_replaceStatement876);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_replaceStatement882);
            value1=literal();

            state._fsp--;

            adaptor.addChild(root_0, value1.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:191:51: (value2= literal )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 71:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:191:52: value2= literal
                    {
                    pushFollow(FOLLOW_literal_in_replaceStatement889);
                    value2=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value2.getTree());

                    }
                    break;

            }


            // org/infinispan/cli/interpreter/IspnQL.g:191:71: (exp= expirationClause )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:191:72: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_replaceStatement898);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set54=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             if ((value2!=null?value2.o:null)==null) retval.stmt = new ReplaceStatement((key!=null?key.key:null), (value1!=null?value1.o:null), (exp!=null?exp.exp:null)); else retval.stmt = new ReplaceStatement((key!=null?key.key:null), (value1!=null?value1.o:null), (value2!=null?value2.o:null), (exp!=null?exp.exp:null));

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "replaceStatement"


    public static class rollbackTransactionStatement_return extends ParserRuleReturnScope {
        public RollbackTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rollbackTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:194:1: rollbackTransactionStatement returns [RollbackTransactionStatement stmt] : ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement() throws RecognitionException {
        IspnQLParser.rollbackTransactionStatement_return retval = new IspnQLParser.rollbackTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ROLLBACK55=null;
        Token set56=null;

        Object cacheName_tree=null;
        Object ROLLBACK55_tree=null;
        Object set56_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:195:4: ( ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:195:6: ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ROLLBACK55=(Token)match(input,ROLLBACK,FOLLOW_ROLLBACK_in_rollbackTransactionStatement930); 
            ROLLBACK55_tree = 
            (Object)adaptor.create(ROLLBACK55)
            ;
            adaptor.addChild(root_0, ROLLBACK55_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:195:15: (cacheName= STRINGLITERAL )?
            int alt17=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt17=1;
                    }
                    break;
            }

            switch (alt17) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:195:16: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement937); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set56=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RollbackTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rollbackTransactionStatement"


    public static class startBatchStatement_return extends ParserRuleReturnScope {
        public StartBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "startBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:198:1: startBatchStatement returns [StartBatchStatement stmt] : START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.startBatchStatement_return startBatchStatement() throws RecognitionException {
        IspnQLParser.startBatchStatement_return retval = new IspnQLParser.startBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token START57=null;
        Token set58=null;

        Object cacheName_tree=null;
        Object START57_tree=null;
        Object set58_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:199:4: ( START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:199:6: START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            START57=(Token)match(input,START,FOLLOW_START_in_startBatchStatement969); 
            START57_tree = 
            (Object)adaptor.create(START57)
            ;
            adaptor.addChild(root_0, START57_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:199:12: (cacheName= STRINGLITERAL )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:199:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_startBatchStatement976); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set58=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StartBatchStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "startBatchStatement"


    public static class statsStatement_return extends ParserRuleReturnScope {
        public StatsStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statsStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:202:1: statsStatement returns [StatsStatement stmt] : STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.statsStatement_return statsStatement() throws RecognitionException {
        IspnQLParser.statsStatement_return retval = new IspnQLParser.statsStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token STATS59=null;
        Token set60=null;
        IspnQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object STATS59_tree=null;
        Object set60_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:203:4: ( STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:203:6: STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            STATS59=(Token)match(input,STATS,FOLLOW_STATS_in_statsStatement1008); 
            STATS59_tree = 
            (Object)adaptor.create(STATS59)
            ;
            adaptor.addChild(root_0, STATS59_tree);


            pushFollow(FOLLOW_statementOptions_in_statsStatement1014);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:203:36: (cacheName= STRINGLITERAL )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:203:37: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statsStatement1021); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set60=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StatsStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statsStatement"


    public static class upgradeStatement_return extends ParserRuleReturnScope {
        public UpgradeStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upgradeStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:206:1: upgradeStatement returns [UpgradeStatement stmt] : UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.upgradeStatement_return upgradeStatement() throws RecognitionException {
        IspnQLParser.upgradeStatement_return retval = new IspnQLParser.upgradeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token UPGRADE61=null;
        Token set62=null;
        IspnQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object UPGRADE61_tree=null;
        Object set62_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:207:4: ( UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:207:6: UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            UPGRADE61=(Token)match(input,UPGRADE,FOLLOW_UPGRADE_in_upgradeStatement1053); 
            UPGRADE61_tree = 
            (Object)adaptor.create(UPGRADE61)
            ;
            adaptor.addChild(root_0, UPGRADE61_tree);


            pushFollow(FOLLOW_statementOptions_in_upgradeStatement1059);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:207:38: (cacheName= STRINGLITERAL )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:207:39: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_upgradeStatement1066); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set62=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new UpgradeStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upgradeStatement"


    public static class versionStatement_return extends ParserRuleReturnScope {
        public VersionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "versionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:210:1: versionStatement returns [VersionStatement stmt] : VERSION ( EOL | ';' ) !;
    public final IspnQLParser.versionStatement_return versionStatement() throws RecognitionException {
        IspnQLParser.versionStatement_return retval = new IspnQLParser.versionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token VERSION63=null;
        Token set64=null;

        Object VERSION63_tree=null;
        Object set64_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:211:4: ( VERSION ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:211:6: VERSION ( EOL | ';' ) !
            {
            VERSION63=(Token)match(input,VERSION,FOLLOW_VERSION_in_versionStatement1098); 
            VERSION63_tree = 
            (Object)adaptor.create(VERSION63)
            ;
            adaptor.addChild(root_0, VERSION63_tree);


            set64=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==68 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new VersionStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "versionStatement"


    public static class expirationClause_return extends ParserRuleReturnScope {
        public ExpirationData exp;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expirationClause"
    // org/infinispan/cli/interpreter/IspnQL.g:214:1: expirationClause returns [ExpirationData exp] : EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? ;
    public final IspnQLParser.expirationClause_return expirationClause() throws RecognitionException {
        IspnQLParser.expirationClause_return retval = new IspnQLParser.expirationClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EXPIRES65=null;
        Token MAXIDLE66=null;
        IspnQLParser.timeLiteral_return expires =null;

        IspnQLParser.timeLiteral_return idle =null;


        Object EXPIRES65_tree=null;
        Object MAXIDLE66_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:215:4: ( EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? )
            // org/infinispan/cli/interpreter/IspnQL.g:215:6: EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )?
            {
            EXPIRES65=(Token)match(input,EXPIRES,FOLLOW_EXPIRES_in_expirationClause1128); 
            EXPIRES65_tree = 
            (Object)adaptor.create(EXPIRES65)
            ;
            adaptor.addChild(root_0, EXPIRES65_tree);


            pushFollow(FOLLOW_timeLiteral_in_expirationClause1134);
            expires=timeLiteral();

            state._fsp--;

            adaptor.addChild(root_0, expires.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:215:36: ( MAXIDLE idle= timeLiteral )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case MAXIDLE:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:215:37: MAXIDLE idle= timeLiteral
                    {
                    MAXIDLE66=(Token)match(input,MAXIDLE,FOLLOW_MAXIDLE_in_expirationClause1137); 
                    MAXIDLE66_tree = 
                    (Object)adaptor.create(MAXIDLE66)
                    ;
                    adaptor.addChild(root_0, MAXIDLE66_tree);


                    pushFollow(FOLLOW_timeLiteral_in_expirationClause1143);
                    idle=timeLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, idle.getTree());

                    }
                    break;

            }


             retval.exp = new ExpirationData((expires!=null?expires.l:null), (idle!=null?idle.l:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expirationClause"


    public static class keyIdentifier_return extends ParserRuleReturnScope {
        public KeyData key;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "keyIdentifier"
    // org/infinispan/cli/interpreter/IspnQL.g:218:1: keyIdentifier returns [KeyData key] : ( STRINGLITERAL '.' literal | literal );
    public final IspnQLParser.keyIdentifier_return keyIdentifier() throws RecognitionException {
        IspnQLParser.keyIdentifier_return retval = new IspnQLParser.keyIdentifier_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL67=null;
        Token char_literal68=null;
        IspnQLParser.literal_return literal69 =null;

        IspnQLParser.literal_return literal70 =null;


        Object STRINGLITERAL67_tree=null;
        Object char_literal68_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:219:4: ( STRINGLITERAL '.' literal | literal )
            int alt22=2;
            switch ( input.LA(1) ) {
            case STRINGLITERAL:
                {
                switch ( input.LA(2) ) {
                case 66:
                    {
                    alt22=1;
                    }
                    break;
                case DOUBLELITERAL:
                case EOL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 68:
                case 71:
                    {
                    alt22=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 22, 1, input);

                    throw nvae;

                }

                }
                break;
            case DOUBLELITERAL:
            case FALSE:
            case FLOATLITERAL:
            case INTLITERAL:
            case LONGLITERAL:
            case NULL:
            case TRUE:
            case UUIDLITERAL:
            case 71:
                {
                alt22=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 22, 0, input);

                throw nvae;

            }

            switch (alt22) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:219:6: STRINGLITERAL '.' literal
                    {
                    STRINGLITERAL67=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_keyIdentifier1166); 
                    STRINGLITERAL67_tree = 
                    (Object)adaptor.create(STRINGLITERAL67)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL67_tree);


                    char_literal68=(Token)match(input,66,FOLLOW_66_in_keyIdentifier1168); 
                    char_literal68_tree = 
                    (Object)adaptor.create(char_literal68)
                    ;
                    adaptor.addChild(root_0, char_literal68_tree);


                    pushFollow(FOLLOW_literal_in_keyIdentifier1170);
                    literal69=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal69.getTree());

                     retval.key = new KeyData(unquote((STRINGLITERAL67!=null?STRINGLITERAL67.getText():null)), (literal69!=null?literal69.o:null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:220:6: literal
                    {
                    pushFollow(FOLLOW_literal_in_keyIdentifier1179);
                    literal70=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal70.getTree());

                     retval.key = new KeyData((literal70!=null?literal70.o:null)); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "keyIdentifier"


    public static class statementOptions_return extends ParserRuleReturnScope {
        public List<Option> options;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOptions"
    // org/infinispan/cli/interpreter/IspnQL.g:223:1: statementOptions returns [List<Option> options] : ( statementOption )* ;
    public final IspnQLParser.statementOptions_return statementOptions() throws RecognitionException {
        IspnQLParser.statementOptions_return retval = new IspnQLParser.statementOptions_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnQLParser.statementOption_return statementOption71 =null;




           retval.options = new ArrayList<Option>();

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:227:4: ( ( statementOption )* )
            // org/infinispan/cli/interpreter/IspnQL.g:227:6: ( statementOption )*
            {
            // org/infinispan/cli/interpreter/IspnQL.g:227:6: ( statementOption )*
            loop23:
            do {
                int alt23=2;
                switch ( input.LA(1) ) {
                case 65:
                    {
                    alt23=1;
                    }
                    break;

                }

                switch (alt23) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:227:8: statementOption
            	    {
            	    pushFollow(FOLLOW_statementOption_in_statementOptions1207);
            	    statementOption71=statementOption();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statementOption71.getTree());

            	     retval.options.add((statementOption71!=null?statementOption71.option:null)); 

            	    }
            	    break;

            	default :
            	    break loop23;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOptions"


    public static class statementOption_return extends ParserRuleReturnScope {
        public Option option;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOption"
    // org/infinispan/cli/interpreter/IspnQL.g:230:1: statementOption returns [Option option] : '--' STRINGLITERAL ;
    public final IspnQLParser.statementOption_return statementOption() throws RecognitionException {
        IspnQLParser.statementOption_return retval = new IspnQLParser.statementOption_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token string_literal72=null;
        Token STRINGLITERAL73=null;

        Object string_literal72_tree=null;
        Object STRINGLITERAL73_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:231:4: ( '--' STRINGLITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:231:6: '--' STRINGLITERAL
            {
            string_literal72=(Token)match(input,65,FOLLOW_65_in_statementOption1231); 
            string_literal72_tree = 
            (Object)adaptor.create(string_literal72)
            ;
            adaptor.addChild(root_0, string_literal72_tree);


            STRINGLITERAL73=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statementOption1233); 
            STRINGLITERAL73_tree = 
            (Object)adaptor.create(STRINGLITERAL73)
            ;
            adaptor.addChild(root_0, STRINGLITERAL73_tree);


             retval.option = new Option(unquote((STRINGLITERAL73!=null?STRINGLITERAL73.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOption"


    public static class literal_return extends ParserRuleReturnScope {
        public Object o;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/infinispan/cli/interpreter/IspnQL.g:234:1: literal returns [Object o] : ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral );
    public final IspnQLParser.literal_return literal() throws RecognitionException {
        IspnQLParser.literal_return retval = new IspnQLParser.literal_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token b=null;
        Token INTLITERAL74=null;
        Token LONGLITERAL75=null;
        Token FLOATLITERAL76=null;
        Token DOUBLELITERAL77=null;
        Token NULL78=null;
        Token STRINGLITERAL79=null;
        Token UUIDLITERAL80=null;
        IspnQLParser.jsonLiteral_return jsonLiteral81 =null;


        Object b_tree=null;
        Object INTLITERAL74_tree=null;
        Object LONGLITERAL75_tree=null;
        Object FLOATLITERAL76_tree=null;
        Object DOUBLELITERAL77_tree=null;
        Object NULL78_tree=null;
        Object STRINGLITERAL79_tree=null;
        Object UUIDLITERAL80_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:235:4: ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral )
            int alt24=9;
            switch ( input.LA(1) ) {
            case INTLITERAL:
                {
                alt24=1;
                }
                break;
            case LONGLITERAL:
                {
                alt24=2;
                }
                break;
            case FLOATLITERAL:
                {
                alt24=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt24=4;
                }
                break;
            case NULL:
                {
                alt24=5;
                }
                break;
            case STRINGLITERAL:
                {
                alt24=6;
                }
                break;
            case UUIDLITERAL:
                {
                alt24=7;
                }
                break;
            case FALSE:
            case TRUE:
                {
                alt24=8;
                }
                break;
            case 71:
                {
                alt24=9;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;

            }

            switch (alt24) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:235:6: INTLITERAL
                    {
                    INTLITERAL74=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_literal1254); 
                    INTLITERAL74_tree = 
                    (Object)adaptor.create(INTLITERAL74)
                    ;
                    adaptor.addChild(root_0, INTLITERAL74_tree);


                     retval.o = Integer.valueOf((INTLITERAL74!=null?INTLITERAL74.getText():null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:236:6: LONGLITERAL
                    {
                    LONGLITERAL75=(Token)match(input,LONGLITERAL,FOLLOW_LONGLITERAL_in_literal1263); 
                    LONGLITERAL75_tree = 
                    (Object)adaptor.create(LONGLITERAL75)
                    ;
                    adaptor.addChild(root_0, LONGLITERAL75_tree);


                     retval.o = Long.valueOf((LONGLITERAL75!=null?LONGLITERAL75.getText():null)); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:237:6: FLOATLITERAL
                    {
                    FLOATLITERAL76=(Token)match(input,FLOATLITERAL,FOLLOW_FLOATLITERAL_in_literal1272); 
                    FLOATLITERAL76_tree = 
                    (Object)adaptor.create(FLOATLITERAL76)
                    ;
                    adaptor.addChild(root_0, FLOATLITERAL76_tree);


                     retval.o = Float.valueOf((FLOATLITERAL76!=null?FLOATLITERAL76.getText():null)); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:238:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL77=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_literal1281); 
                    DOUBLELITERAL77_tree = 
                    (Object)adaptor.create(DOUBLELITERAL77)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL77_tree);


                     retval.o = Double.valueOf((DOUBLELITERAL77!=null?DOUBLELITERAL77.getText():null)); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:239:6: NULL
                    {
                    NULL78=(Token)match(input,NULL,FOLLOW_NULL_in_literal1290); 
                    NULL78_tree = 
                    (Object)adaptor.create(NULL78)
                    ;
                    adaptor.addChild(root_0, NULL78_tree);


                     retval.o = null; 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:240:6: STRINGLITERAL
                    {
                    STRINGLITERAL79=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_literal1299); 
                    STRINGLITERAL79_tree = 
                    (Object)adaptor.create(STRINGLITERAL79)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL79_tree);


                     retval.o = unquote((STRINGLITERAL79!=null?STRINGLITERAL79.getText():null)); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:241:6: UUIDLITERAL
                    {
                    UUIDLITERAL80=(Token)match(input,UUIDLITERAL,FOLLOW_UUIDLITERAL_in_literal1308); 
                    UUIDLITERAL80_tree = 
                    (Object)adaptor.create(UUIDLITERAL80)
                    ;
                    adaptor.addChild(root_0, UUIDLITERAL80_tree);


                     retval.o = UUID.fromString((UUIDLITERAL80!=null?UUIDLITERAL80.getText():null)); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:242:6: b= ( TRUE | FALSE )
                    {
                    b=(Token)input.LT(1);

                    if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(b)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                     retval.o = Boolean.valueOf((b!=null?b.getText():null)); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:243:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_literal1338);
                    jsonLiteral81=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral81.getTree());


                           retval.o = jsonMapper.readValue((jsonLiteral81!=null?input.toString(jsonLiteral81.start,jsonLiteral81.stop):null), Object.class);
                       

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (JsonProcessingException jpe) {
             throw new RecognitionException(input); 
        }
        catch (IOException ioe) {
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class timeLiteral_return extends ParserRuleReturnScope {
        public Long l;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:250:1: timeLiteral returns [Long l] : TIMELITERAL ;
    public final IspnQLParser.timeLiteral_return timeLiteral() throws RecognitionException {
        IspnQLParser.timeLiteral_return retval = new IspnQLParser.timeLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token TIMELITERAL82=null;

        Object TIMELITERAL82_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:251:4: ( TIMELITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:251:6: TIMELITERAL
            {
            TIMELITERAL82=(Token)match(input,TIMELITERAL,FOLLOW_TIMELITERAL_in_timeLiteral1375); 
            TIMELITERAL82_tree = 
            (Object)adaptor.create(TIMELITERAL82)
            ;
            adaptor.addChild(root_0, TIMELITERAL82_tree);


             retval.l = millis((TIMELITERAL82!=null?TIMELITERAL82.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeLiteral"


    public static class jsonLiteral_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:254:1: jsonLiteral : '{' jsonPair ( ',' jsonPair )* '}' ;
    public final IspnQLParser.jsonLiteral_return jsonLiteral() throws RecognitionException {
        IspnQLParser.jsonLiteral_return retval = new IspnQLParser.jsonLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal83=null;
        Token char_literal85=null;
        Token char_literal87=null;
        IspnQLParser.jsonPair_return jsonPair84 =null;

        IspnQLParser.jsonPair_return jsonPair86 =null;


        Object char_literal83_tree=null;
        Object char_literal85_tree=null;
        Object char_literal87_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:255:4: ( '{' jsonPair ( ',' jsonPair )* '}' )
            // org/infinispan/cli/interpreter/IspnQL.g:255:6: '{' jsonPair ( ',' jsonPair )* '}'
            {
            char_literal83=(Token)match(input,71,FOLLOW_71_in_jsonLiteral1392); 
            char_literal83_tree = 
            (Object)adaptor.create(char_literal83)
            ;
            adaptor.addChild(root_0, char_literal83_tree);


            pushFollow(FOLLOW_jsonPair_in_jsonLiteral1394);
            jsonPair84=jsonPair();

            state._fsp--;

            adaptor.addChild(root_0, jsonPair84.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:255:19: ( ',' jsonPair )*
            loop25:
            do {
                int alt25=2;
                switch ( input.LA(1) ) {
                case 64:
                    {
                    alt25=1;
                    }
                    break;

                }

                switch (alt25) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:255:20: ',' jsonPair
            	    {
            	    char_literal85=(Token)match(input,64,FOLLOW_64_in_jsonLiteral1397); 
            	    char_literal85_tree = 
            	    (Object)adaptor.create(char_literal85)
            	    ;
            	    adaptor.addChild(root_0, char_literal85_tree);


            	    pushFollow(FOLLOW_jsonPair_in_jsonLiteral1399);
            	    jsonPair86=jsonPair();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonPair86.getTree());

            	    }
            	    break;

            	default :
            	    break loop25;
                }
            } while (true);


            char_literal87=(Token)match(input,72,FOLLOW_72_in_jsonLiteral1403); 
            char_literal87_tree = 
            (Object)adaptor.create(char_literal87)
            ;
            adaptor.addChild(root_0, char_literal87_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonLiteral"


    public static class jsonPair_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonPair"
    // org/infinispan/cli/interpreter/IspnQL.g:258:1: jsonPair : jsonString ':' jsonValue ;
    public final IspnQLParser.jsonPair_return jsonPair() throws RecognitionException {
        IspnQLParser.jsonPair_return retval = new IspnQLParser.jsonPair_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal89=null;
        IspnQLParser.jsonString_return jsonString88 =null;

        IspnQLParser.jsonValue_return jsonValue90 =null;


        Object char_literal89_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:259:4: ( jsonString ':' jsonValue )
            // org/infinispan/cli/interpreter/IspnQL.g:259:6: jsonString ':' jsonValue
            {
            pushFollow(FOLLOW_jsonString_in_jsonPair1418);
            jsonString88=jsonString();

            state._fsp--;

            adaptor.addChild(root_0, jsonString88.getTree());

            char_literal89=(Token)match(input,67,FOLLOW_67_in_jsonPair1420); 
            char_literal89_tree = 
            (Object)adaptor.create(char_literal89)
            ;
            adaptor.addChild(root_0, char_literal89_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonPair1422);
            jsonValue90=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue90.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonPair"


    public static class jsonString_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonString"
    // org/infinispan/cli/interpreter/IspnQL.g:262:1: jsonString : STRINGLITERAL ;
    public final IspnQLParser.jsonString_return jsonString() throws RecognitionException {
        IspnQLParser.jsonString_return retval = new IspnQLParser.jsonString_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL91=null;

        Object STRINGLITERAL91_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:263:4: ( STRINGLITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:263:6: STRINGLITERAL
            {
            STRINGLITERAL91=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_jsonString1437); 
            STRINGLITERAL91_tree = 
            (Object)adaptor.create(STRINGLITERAL91)
            ;
            adaptor.addChild(root_0, STRINGLITERAL91_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonString"


    public static class jsonValue_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonValue"
    // org/infinispan/cli/interpreter/IspnQL.g:266:1: jsonValue : ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString );
    public final IspnQLParser.jsonValue_return jsonValue() throws RecognitionException {
        IspnQLParser.jsonValue_return retval = new IspnQLParser.jsonValue_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INTLITERAL94=null;
        Token DOUBLELITERAL95=null;
        Token TRUE96=null;
        Token FALSE97=null;
        Token NULL98=null;
        IspnQLParser.jsonLiteral_return jsonLiteral92 =null;

        IspnQLParser.jsonArray_return jsonArray93 =null;

        IspnQLParser.jsonString_return jsonString99 =null;


        Object INTLITERAL94_tree=null;
        Object DOUBLELITERAL95_tree=null;
        Object TRUE96_tree=null;
        Object FALSE97_tree=null;
        Object NULL98_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:267:4: ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString )
            int alt26=8;
            switch ( input.LA(1) ) {
            case 71:
                {
                alt26=1;
                }
                break;
            case 69:
                {
                alt26=2;
                }
                break;
            case INTLITERAL:
                {
                alt26=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt26=4;
                }
                break;
            case TRUE:
                {
                alt26=5;
                }
                break;
            case FALSE:
                {
                alt26=6;
                }
                break;
            case NULL:
                {
                alt26=7;
                }
                break;
            case STRINGLITERAL:
                {
                alt26=8;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 26, 0, input);

                throw nvae;

            }

            switch (alt26) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:267:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_jsonValue1452);
                    jsonLiteral92=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral92.getTree());

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:268:6: jsonArray
                    {
                    pushFollow(FOLLOW_jsonArray_in_jsonValue1459);
                    jsonArray93=jsonArray();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonArray93.getTree());

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:269:6: INTLITERAL
                    {
                    INTLITERAL94=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_jsonValue1466); 
                    INTLITERAL94_tree = 
                    (Object)adaptor.create(INTLITERAL94)
                    ;
                    adaptor.addChild(root_0, INTLITERAL94_tree);


                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:270:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL95=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_jsonValue1473); 
                    DOUBLELITERAL95_tree = 
                    (Object)adaptor.create(DOUBLELITERAL95)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL95_tree);


                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:271:6: TRUE
                    {
                    TRUE96=(Token)match(input,TRUE,FOLLOW_TRUE_in_jsonValue1480); 
                    TRUE96_tree = 
                    (Object)adaptor.create(TRUE96)
                    ;
                    adaptor.addChild(root_0, TRUE96_tree);


                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:271:13: FALSE
                    {
                    FALSE97=(Token)match(input,FALSE,FOLLOW_FALSE_in_jsonValue1484); 
                    FALSE97_tree = 
                    (Object)adaptor.create(FALSE97)
                    ;
                    adaptor.addChild(root_0, FALSE97_tree);


                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:272:6: NULL
                    {
                    NULL98=(Token)match(input,NULL,FOLLOW_NULL_in_jsonValue1491); 
                    NULL98_tree = 
                    (Object)adaptor.create(NULL98)
                    ;
                    adaptor.addChild(root_0, NULL98_tree);


                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:273:6: jsonString
                    {
                    pushFollow(FOLLOW_jsonString_in_jsonValue1498);
                    jsonString99=jsonString();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonString99.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonValue"


    public static class jsonArray_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonArray"
    // org/infinispan/cli/interpreter/IspnQL.g:276:1: jsonArray : '[' jsonValue ( ',' jsonValue )* ']' ;
    public final IspnQLParser.jsonArray_return jsonArray() throws RecognitionException {
        IspnQLParser.jsonArray_return retval = new IspnQLParser.jsonArray_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal100=null;
        Token char_literal102=null;
        Token char_literal104=null;
        IspnQLParser.jsonValue_return jsonValue101 =null;

        IspnQLParser.jsonValue_return jsonValue103 =null;


        Object char_literal100_tree=null;
        Object char_literal102_tree=null;
        Object char_literal104_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:277:4: ( '[' jsonValue ( ',' jsonValue )* ']' )
            // org/infinispan/cli/interpreter/IspnQL.g:277:6: '[' jsonValue ( ',' jsonValue )* ']'
            {
            char_literal100=(Token)match(input,69,FOLLOW_69_in_jsonArray1513); 
            char_literal100_tree = 
            (Object)adaptor.create(char_literal100)
            ;
            adaptor.addChild(root_0, char_literal100_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonArray1515);
            jsonValue101=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue101.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:277:20: ( ',' jsonValue )*
            loop27:
            do {
                int alt27=2;
                switch ( input.LA(1) ) {
                case 64:
                    {
                    alt27=1;
                    }
                    break;

                }

                switch (alt27) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:277:21: ',' jsonValue
            	    {
            	    char_literal102=(Token)match(input,64,FOLLOW_64_in_jsonArray1518); 
            	    char_literal102_tree = 
            	    (Object)adaptor.create(char_literal102)
            	    ;
            	    adaptor.addChild(root_0, char_literal102_tree);


            	    pushFollow(FOLLOW_jsonValue_in_jsonArray1520);
            	    jsonValue103=jsonValue();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonValue103.getTree());

            	    }
            	    break;

            	default :
            	    break loop27;
                }
            } while (true);


            char_literal104=(Token)match(input,70,FOLLOW_70_in_jsonArray1524); 
            char_literal104_tree = 
            (Object)adaptor.create(char_literal104)
            ;
            adaptor.addChild(root_0, char_literal104_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonArray"

    // Delegated rules


 

    public static final BitSet FOLLOW_statement_in_statements72 = new BitSet(new long[]{0x4207F011101C0F90L});
    public static final BitSet FOLLOW_EOL_in_statements76 = new BitSet(new long[]{0x4207F011101C0F90L});
    public static final BitSet FOLLOW_EOF_in_statements81 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_abortBatchStatement_in_statement100 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_beginTransactionStatement_in_statement109 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cacheStatement_in_statement118 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_clearStatement_in_statement127 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_commitTransactionStatement_in_statement136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createStatement_in_statement145 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_endBatchStatement_in_statement154 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_evictStatement_in_statement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_getStatement_in_statement172 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_infoStatement_in_statement181 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateStatement_in_statement190 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putIfAbsentStatement_in_statement199 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putStatement_in_statement208 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_removeStatement_in_statement217 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_replaceStatement_in_statement226 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rollbackTransactionStatement_in_statement235 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_startBatchStatement_in_statement244 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statsStatement_in_statement253 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upgradeStatement_in_statement262 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_versionStatement_in_statement271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ABORT_in_abortBatchStatement293 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_abortBatchStatement300 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_abortBatchStatement304 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BEGIN_in_beginTransactionStatement332 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_beginTransactionStatement339 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_beginTransactionStatement343 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CACHE_in_cacheStatement371 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_cacheStatement378 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_cacheStatement382 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CLEAR_in_clearStatement410 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_clearStatement417 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_clearStatement420 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COMMIT_in_commitTransactionStatement448 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_commitTransactionStatement455 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_commitTransactionStatement459 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CREATE_in_createStatement487 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement493 = new BitSet(new long[]{0x0000000800080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_LIKE_in_createStatement496 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement502 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_createStatement506 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_END_in_endBatchStatement537 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_endBatchStatement544 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_endBatchStatement548 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EVICT_in_evictStatement576 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_keyIdentifier_in_evictStatement582 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_evictStatement584 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GET_in_getStatement612 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_keyIdentifier_in_getStatement618 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_getStatement620 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INFO_in_infoStatement648 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_infoStatement655 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_infoStatement659 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LOCATE_in_locateStatement687 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_keyIdentifier_in_locateStatement693 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_locateStatement695 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUTIFABSENT_in_putIfAbsentStatement723 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_keyIdentifier_in_putIfAbsentStatement729 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_literal_in_putIfAbsentStatement735 = new BitSet(new long[]{0x0000000000280000L,0x0000000000000010L});
    public static final BitSet FOLLOW_expirationClause_in_putIfAbsentStatement742 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_putIfAbsentStatement746 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUT_in_putStatement774 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_keyIdentifier_in_putStatement780 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_literal_in_putStatement786 = new BitSet(new long[]{0x0000000000280000L,0x0000000000000010L});
    public static final BitSet FOLLOW_expirationClause_in_putStatement793 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_putStatement797 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REMOVE_in_removeStatement825 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_keyIdentifier_in_removeStatement831 = new BitSet(new long[]{0x0488022206084000L,0x0000000000000090L});
    public static final BitSet FOLLOW_literal_in_removeStatement838 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_removeStatement842 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REPLACE_in_replaceStatement870 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_keyIdentifier_in_replaceStatement876 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_literal_in_replaceStatement882 = new BitSet(new long[]{0x0488022206284000L,0x0000000000000090L});
    public static final BitSet FOLLOW_literal_in_replaceStatement889 = new BitSet(new long[]{0x0000000000280000L,0x0000000000000010L});
    public static final BitSet FOLLOW_expirationClause_in_replaceStatement898 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_replaceStatement902 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ROLLBACK_in_rollbackTransactionStatement930 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement937 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_rollbackTransactionStatement941 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_START_in_startBatchStatement969 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_startBatchStatement976 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_startBatchStatement980 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STATS_in_statsStatement1008 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000012L});
    public static final BitSet FOLLOW_statementOptions_in_statsStatement1014 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statsStatement1021 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_statsStatement1025 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UPGRADE_in_upgradeStatement1053 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000012L});
    public static final BitSet FOLLOW_statementOptions_in_upgradeStatement1059 = new BitSet(new long[]{0x0008000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_upgradeStatement1066 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_upgradeStatement1070 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VERSION_in_versionStatement1098 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000010L});
    public static final BitSet FOLLOW_set_in_versionStatement1100 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPIRES_in_expirationClause1128 = new BitSet(new long[]{0x0040000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1134 = new BitSet(new long[]{0x0000010000000002L});
    public static final BitSet FOLLOW_MAXIDLE_in_expirationClause1137 = new BitSet(new long[]{0x0040000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1143 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_keyIdentifier1166 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_66_in_keyIdentifier1168 = new BitSet(new long[]{0x0488022206004000L,0x0000000000000080L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1170 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1179 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statementOption_in_statementOptions1207 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000002L});
    public static final BitSet FOLLOW_65_in_statementOption1231 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statementOption1233 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_literal1254 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LONGLITERAL_in_literal1263 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOATLITERAL_in_literal1272 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_literal1281 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_literal1290 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_literal1299 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUIDLITERAL_in_literal1308 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_literal1321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_literal1338 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMELITERAL_in_timeLiteral1375 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_71_in_jsonLiteral1392 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1394 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000101L});
    public static final BitSet FOLLOW_64_in_jsonLiteral1397 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1399 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000101L});
    public static final BitSet FOLLOW_72_in_jsonLiteral1403 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonPair1418 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_67_in_jsonPair1420 = new BitSet(new long[]{0x0088020202004000L,0x00000000000000A0L});
    public static final BitSet FOLLOW_jsonValue_in_jsonPair1422 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_jsonString1437 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_jsonValue1452 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonArray_in_jsonValue1459 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_jsonValue1466 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_jsonValue1473 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_jsonValue1480 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_jsonValue1484 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_jsonValue1491 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonValue1498 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_69_in_jsonArray1513 = new BitSet(new long[]{0x0088020202004000L,0x00000000000000A0L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1515 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000041L});
    public static final BitSet FOLLOW_64_in_jsonArray1518 = new BitSet(new long[]{0x0088020202004000L,0x00000000000000A0L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1520 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000041L});
    public static final BitSet FOLLOW_70_in_jsonArray1524 = new BitSet(new long[]{0x0000000000000002L});

}