/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.session;

import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;

public class SessionImpl
implements Session {
    private final EmbeddedCacheManager cacheManager;
    private final String id;
    private Cache<?, ?> cache = null;
    private String cacheName = null;
    private long timestamp;

    public SessionImpl(EmbeddedCacheManager cacheManager, String id) {
        this.cacheManager = cacheManager;
        this.id = id;
        this.timestamp = System.nanoTime();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public <K, V> Cache<K, V> getCurrentCache() {
        return this.cache;
    }

    @Override
    public String getCurrentCacheName() {
        return this.cacheName;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        Cache c = cacheName != null ? this.cacheManager.getCache(cacheName, false) : this.getCurrentCache();
        if (c == null) {
            throw new IllegalArgumentException("No cache named " + cacheName);
        }
        return c;
    }

    @Override
    public void setCurrentCache(String cacheName) {
        this.cache = this.getCache(cacheName);
        this.cacheName = cacheName;
    }

    @Override
    public void createCache(String cacheName, String baseCacheName) {
        Configuration configuration;
        if (baseCacheName != null) {
            configuration = this.cacheManager.getCacheConfiguration(baseCacheName);
            if (configuration == null) {
                throw new IllegalArgumentException("A cache named " + baseCacheName + " doesn't exist");
            }
        } else {
            configuration = this.cacheManager.getDefaultCacheConfiguration();
            baseCacheName = "___defaultcache";
        }
        if (this.cacheManager.cacheExists(cacheName)) {
            throw new IllegalArgumentException("A cache named " + cacheName + " already exists");
        }
        if (configuration.clustering().cacheMode().isClustered()) {
            AdvancedCache clusteredCache = this.cacheManager.getCache(baseCacheName).getAdvancedCache();
            RpcManager rpc = clusteredCache.getRpcManager();
            CommandsFactory factory = (CommandsFactory)clusteredCache.getComponentRegistry().getComponent(CommandsFactory.class);
            CreateCacheCommand ccc = factory.buildCreateCacheCommand(cacheName, baseCacheName);
            try {
                rpc.invokeRemotely(null, (ReplicableCommand)ccc, true, false);
                ccc.init(this.cacheManager);
                ccc.perform(null);
            }
            catch (Throwable e) {
                throw new CacheException("Could not create cache on all clustered nodes", e);
            }
        } else {
            ConfigurationBuilder b = new ConfigurationBuilder();
            b.read(configuration);
            this.cacheManager.defineConfiguration(cacheName, b.build());
            this.cacheManager.getCache(cacheName);
        }
    }

    @Override
    public void reset() {
        this.resetCache((Cache<Object, Object>)this.cacheManager.getCache());
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.resetCache((Cache<Object, Object>)this.cacheManager.getCache(cacheName));
        }
        this.timestamp = System.nanoTime();
    }

    private void resetCache(Cache<Object, Object> cache) {
        if (cache.getCacheConfiguration().invocationBatching().enabled()) {
            cache.endBatch(false);
        }
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        try {
            if (tm.getTransaction() != null) {
                tm.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

