/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.logging;

import java.util.ServiceConfigurationError;
import javax.transaction.SystemException;
import org.infinispan.CacheException;
import org.infinispan.cli.interpreter.codec.CodecException;
import org.infinispan.cli.interpreter.result.StatementException;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends org.infinispan.util.logging.Log {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not register interpreter MBean", id=19001)
    public void jmxRegistrationFailed();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not unregister interpreter MBean", id=19002)
    public void jmxUnregistrationFailed();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Interpreter error", id=19003)
    public void interpreterError(@Cause Throwable var1);

    @Message(value="No action has been specified for the upgrade command", id=19004)
    public StatementException missingUpgradeAction();

    @Message(value="No migrator has been specified", id=19005)
    public StatementException missingMigrator();

    @Message(value="Unknown option '%s'", id=19006)
    public StatementException unknownOption(String var1);

    @Message(value="The option %s requires a parameter", id=19007)
    public StatementException missingOptionParameter(String var1);

    @Message(value="Failure while encoding key using codec '%s'", id=19008)
    public CodecException keyEncodingFailed(@Cause Exception var1, String var2);

    @Message(value="Failure while decoding key using codec '%s'", id=19009)
    public CodecException keyDecodingFailed(@Cause Exception var1, String var2);

    @Message(value="Failure while encoding value using codec '%s'", id=19010)
    public CodecException valueEncodingFailed(@Cause Exception var1, String var2);

    @Message(value="Failure while decoding value using codec '%s'", id=19011)
    public CodecException valueDecodingFailed(@Cause Exception var1, String var2);

    @Message(value="No such codec named '%s'", id=19012)
    public CodecException noSuchCodec(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="There was an error loading a codec", id=19013)
    public void loadingCodecFailed(@Cause ServiceConfigurationError var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Codec '%s' attempts to override codec '%s'", id=19014)
    public void duplicateCodec(String var1, String var2);

    @Message(value="Invalid session id '%s'", id=19015)
    public IllegalArgumentException invalidSession(String var1);

    @Message(value="No such cache: '%s'", id=19016)
    public IllegalArgumentException nonExistentCache(String var1);

    @Message(value="A cache named '%s' already exists", id=19017)
    public IllegalArgumentException cacheAlreadyExists(String var1);

    @Message(value="Could not create cache named '%s' on all cluster nodes", id=19018)
    public CacheException cannotCreateClusteredCaches(@Cause Throwable var1, String var2);

    @Message(value="Statistics not enabled on cache '%s'", id=19019)
    public StatementException statisticsNotEnabled(String var1);

    @Message(value="Cannot retrieve a transaction manager", id=19020)
    public StatementException noTransactionManager();

    @Message(value="The TransactionManager does not support nested transactions", id=19021)
    public StatementException noNestedTransactions();

    @Message(value="Unexpected error while starting transaction", id=19022)
    public StatementException unexpectedTransactionError(@Cause SystemException var1);

    @Message(value="Cannot commit transaction", id=19023)
    public StatementException cannotCommitTransaction(@Cause Exception var1);

    @Message(value="Cache is not distributed", id=19024)
    public StatementException cacheNotDistributed();

    @Message(value="Cannot rollback transaction", id=19025)
    public StatementException cannotRollbackTransaction(@Cause Exception var1);

    @Message(value="An error occurred while synchronizing data for cache '%s' using migrator '%s' from the source server", id=19026)
    public StatementException dataSynchronizationError(@Cause Exception var1, String var2, String var3);

    @Message(value="An error occurred while disconnecting the source server for cache '%s' using migrator '%s'", id=19027)
    public StatementException sourceDisconnectionError(@Cause Exception var1, String var2, String var3);

    @Message(value="A site name needs to be specified", id=19028)
    public StatementException siteNameNotSpecified();

    @Message(value="No cache selected yet", id=19029)
    public StatementException noCacheSelectedYet();

    @Message(value="Failure while encoding value of type '%s' using codec '%s'", id=19030)
    public CodecException valueEncodingFailed(String var1, String var2);
}

