/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="cli-server.SiteStatementTest")
public class SiteStatementTest
extends AbstractTwoSitesTest {
    protected ConfigurationBuilder getNycActiveConfig() {
        return SiteStatementTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
    }

    protected ConfigurationBuilder getLonActiveConfig() {
        return SiteStatementTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
    }

    public void testSiteStatus() throws Exception {
        Interpreter lonInterpreter = this.interpreter("LON", 0);
        String lonCache = this.cache("LON", 0).getName();
        String lonSessionId = lonInterpreter.createSessionId(lonCache);
        Interpreter nycInterpreter = this.interpreter("NYC", 0);
        String nycCache = this.cache("NYC", 0).getName();
        String nycSessionId = nycInterpreter.createSessionId(nycCache);
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --status NYC;", "online");
        this.assertInterpreterOutput(nycInterpreter, nycSessionId, String.format("site --status %s.LON;", lonCache), "online");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --offline NYC;", "ok");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --online NYC;", "ok");
    }

    private void assertInterpreterOutput(Interpreter interpreter, String sessionId, String command, String output) throws Exception {
        Map result = interpreter.execute(sessionId, command);
        AssertJUnit.assertEquals((String)output, (String)((String)result.get(ResultKeys.OUTPUT.toString())));
    }

    private Interpreter interpreter(String site, int cache) {
        return (Interpreter)this.cache(site, cache).getAdvancedCache().getComponentRegistry().getComponent(Interpreter.class);
    }
}

