/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.codec;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CodecRegistry {
    public static final Log log = (Log)LogFactory.getLog(CodecRegistry.class, Log.class);
    private Map<String, Codec> codecs = new HashMap<String, Codec>();

    public CodecRegistry(ClassLoader cl) {
        ServiceLoader<Codec> services = ServiceLoader.load(Codec.class, cl);
        Iterator<Codec> it = services.iterator();
        while (true) {
            try {
                while (true) {
                    Codec codec;
                    String name;
                    if (this.codecs.containsKey(name = (codec = it.next()).getName())) {
                        log.duplicateCodec(codec.getClass().getName(), this.codecs.get(name).getClass().getName());
                        continue;
                    }
                    this.codecs.put(name, codec);
                }
            }
            catch (ServiceConfigurationError e) {
                log.loadingCodecFailed(e);
                continue;
            }
            catch (NoSuchElementException e) {
                return;
            }
            break;
        }
    }

    public Collection<Codec> getCodecs() {
        return this.codecs.values();
    }

    public Codec getCodec(String name) {
        return this.codecs.get(name);
    }
}

