/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.MyClass;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.cli.interpreter.statement.CacheStatement;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli-server.InterpreterTest")
public class InterpreterTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.jmxStatistics().enable().dataContainer().invocationBatching().enable();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)c);
    }

    private Interpreter getInterpreter() {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        return interpreter;
    }

    public void testSimple() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "put 'a' 'b'; get 'a';");
        interpreter.execute(sessionId, "put 'c' {\"org.infinispan.cli.interpreter.MyClass\":{\"i\":5,\"x\":null,\"b\":true}};");
        Object o = this.cache.get((Object)"c");
        assert (o != null);
        assert (o instanceof MyClass);
        assert (((MyClass)o).i == 5);
        assert (((MyClass)o).b);
        interpreter.execute(sessionId, "put 'f' 0.5;");
        Double f = (Double)this.cache.get((Object)"f");
        assert (f == 0.5);
    }

    public void testPutIfAbsent() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "put 'a' 'a'; put --ifabsent 'a' 'b';");
        AssertJUnit.assertEquals((String)"a", (String)((String)this.cache.get((Object)"a")));
    }

    public void testCacheQualifier() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        Cache otherCache = this.cacheManager.getCache("otherCache");
        interpreter.execute(sessionId, "put 'a' 'a'; put 'otherCache'.'b' 'b'; cache 'otherCache'; put 'c' 'c';");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        Object b = otherCache.get((Object)"b");
        assert (b.equals("b"));
        Object c = otherCache.get((Object)"c");
        assert (c.equals("c"));
    }

    public void testBatching() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "start; put 'a' 'a'; put 'b' 'b'; end;");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        Object b = this.cache.get((Object)"b");
        assert (b.equals("b"));
    }

    public void testTx() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "begin; put 'a' 'a'; commit;");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        interpreter.execute(sessionId, "begin; put 'b' 'b'; rollback;");
        assert (!this.cache.containsKey((Object)"b"));
    }

    public void testDangling() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "begin; put 'a' 'a';");
        assert (this.cache.getAdvancedCache().getTransactionManager().getTransaction() == null);
        assert (!this.cache.containsKey((Object)"a"));
        interpreter.execute(sessionId, "start; put 'a' 'a';");
        assert (this.cache.getAdvancedCache().getBatchContainer().getBatchTransaction() == null);
        assert (!this.cache.containsKey((Object)"a"));
    }

    public void testRemove() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "put 'a' 'a';");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        interpreter.execute(sessionId, "remove 'a';");
        assert (!this.cache.containsKey((Object)"a"));
        interpreter.execute(sessionId, "put 'b' 'b';");
        Object b = this.cache.get((Object)"b");
        assert (b.equals("b"));
        interpreter.execute(sessionId, "remove 'b' 'c';");
        assert (this.cache.containsKey((Object)"b"));
    }

    public void testReplace() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "put 'a' 'a';");
        Object a = this.cache.get((Object)"a");
        assert (a.equals("a"));
        interpreter.execute(sessionId, "replace 'a' 'b';");
        a = this.cache.get((Object)"a");
        assert (a.equals("b"));
        interpreter.execute(sessionId, "replace 'a' 'b' 'c';");
        a = this.cache.get((Object)"a");
        assert (a.equals("c"));
        interpreter.execute(sessionId, "replace 'a' 'b' 'd';");
        a = this.cache.get((Object)"a");
        assert (a.equals("c"));
    }

    public void testCreateLocal() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "create newcache;");
        assert (this.cacheManager.cacheExists("newcache"));
        interpreter.execute(sessionId, "create anothercache like newcache;");
        assert (this.cacheManager.cacheExists("anothercache"));
    }

    public void testUpgrade() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "upgrade --dumpkeys;");
    }

    public void testInvalidSession() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = "123";
        Map response = interpreter.execute(sessionId, "put 'a' 'a';");
        assert (response.containsKey(ResultKeys.ERROR.toString()));
    }

    public void testCacheNotYetSelected() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId(null);
        Map response = interpreter.execute(sessionId, "cache;");
        assert (response.containsKey(ResultKeys.ERROR.toString()));
        String errorMsg = ((Log)LogFactory.getLog(CacheStatement.class, Log.class)).noCacheSelectedYet().getMessage();
        assert (((String)response.get(ResultKeys.ERROR.toString())).contains(errorMsg));
    }

    public void testStats() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        Map response = interpreter.execute(sessionId, "stats;");
        assert (!response.containsKey(ResultKeys.ERROR.toString()));
        response = interpreter.execute(sessionId, "stats --container;");
        assert (!response.containsKey(ResultKeys.ERROR.toString()));
    }

    public void testParserErrors() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        Map response = interpreter.execute(sessionId, "got a;");
        AssertJUnit.assertTrue((boolean)response.containsKey(ResultKeys.ERROR.toString()));
    }

    public void testTemporarySession() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        Map response = interpreter.execute(null, "put 'a' 'a';");
        AssertJUnit.assertFalse((boolean)response.containsKey(ResultKeys.ERROR.toString()));
        AssertJUnit.assertEquals((String)"a", (String)((String)this.cache.get((Object)"a")));
    }
}

