/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    SecurityActions() {
    }

    public static ClassLoader setThreadContextClassLoader(Class cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    public static ClassLoader setThreadContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    static interface SetThreadContextClassLoaderAction {
        public static final SetThreadContextClassLoaderAction NON_PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(Class cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                return old;
            }

            @Override
            public ClassLoader setThreadContextClassLoader(ClassLoader cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                return old;
            }
        };
        public static final SetThreadContextClassLoaderAction PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(final Class cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                        return old;
                    }
                });
            }

            @Override
            public ClassLoader setThreadContextClassLoader(final ClassLoader cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl);
                        return old;
                    }
                });
            }
        };

        public ClassLoader setThreadContextClassLoader(Class var1);

        public ClassLoader setThreadContextClassLoader(ClassLoader var1);
    }
}

