/*
 * JBoss, Home of Professional Open Source
 * Copyright 2014 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedCommandBuilder;
import org.jboss.aesh.cl.internal.ProcessedOptionBuilder;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserBuilder;

/**
 * @author <a href="mailto:stale.pedersen@jboss.org">Ståle W. Pedersen</a>
 */
public class Main {
    public static final void main(String[] args) throws Exception {
        ProcessedCommand<?> options = options = buildCommandLineOptions();
        CommandLineParser<?> parser = new CommandLineParserBuilder().processedCommand(options).create();
        StringBuilder argLine = new StringBuilder("mycmd");
        for (String str : args) {
            argLine.append(' ').append(str);
        }

        CommandLine<?> commandLine = parser.parse(argLine.toString());
        if (commandLine.getParserException() != null) {
            throw commandLine.getParserException();
        }

        System.out.println("hasOption(abc)=" + commandLine.hasOption("abc"));
        System.out.println("abc=" + commandLine.getOptionValue("abc", "<not set>"));
        System.out.println("hasOption(myoption)=" + commandLine.hasOption("myoption"));
        System.out.println("myoption=" + commandLine.getOptionValue("myoption", "<not set>"));
    }

    private static ProcessedCommand<?> buildCommandLineOptions() throws Exception {
        ProcessedCommandBuilder cmd = new ProcessedCommandBuilder();

        cmd.name("mycmd");

        cmd.addOption(new ProcessedOptionBuilder()
                .name("abc")
                .optionType(OptionType.NORMAL)
                .type(String.class)
                .create());
        cmd.addOption(new ProcessedOptionBuilder()
                .name("myoption")
                .optionType(OptionType.NORMAL)
                .type(String.class)
                .addDefaultValue("")
                .create());

        return cmd.create();
    }
}