/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cloudevents.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.cloudevents.configuration.Attribute;
import org.infinispan.cloudevents.configuration.CloudEventsConfigurationBuilder;
import org.infinispan.cloudevents.configuration.CloudEventsGlobalConfigurationBuilder;
import org.infinispan.cloudevents.configuration.Element;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;

@Namespaces(value={@Namespace(root="cloudevents"), @Namespace(root="cloudevents-cache"), @Namespace(uri="urn:infinispan:config:cloudevents:*", root="cloudevents", since="12.0"), @Namespace(uri="urn:infinispan:config:cloudevents:*", root="cloudevents-cache", since="12.0")})
public class CloudEventsConfigurationParser
implements ConfigurationParser {
    static final String PREFIX = "cloudevents";
    static final String NAMESPACE = "urn:infinispan:config:cloudevents:";

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (holder.inScope((Enum)ParserScope.CACHE_CONTAINER)) {
            GlobalConfigurationBuilder globalBuilder = holder.getGlobalConfigurationBuilder();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLOUDEVENTS: {
                    CloudEventsGlobalConfigurationBuilder cloudEventsGlobalBuilder = (CloudEventsGlobalConfigurationBuilder)globalBuilder.addModule(CloudEventsGlobalConfigurationBuilder.class);
                    this.parseGlobalCloudEvents(reader, cloudEventsGlobalBuilder);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        } else if (holder.inScope((Enum)ParserScope.CACHE) || holder.inScope((Enum)ParserScope.CACHE_TEMPLATE)) {
            ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLOUDEVENTS_CACHE: {
                    CloudEventsConfigurationBuilder cloudEventsBuilder = (CloudEventsConfigurationBuilder)builder.addModule(CloudEventsConfigurationBuilder.class);
                    this.parseCacheCloudEvents(reader, cloudEventsBuilder);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                }
            }
        } else {
            throw new IllegalStateException("WRONG SCOPE");
        }
    }

    private void parseGlobalCloudEvents(XMLExtendedStreamReader reader, CloudEventsGlobalConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BOOTSTRAP_SERVERS: {
                    builder.bootstrapServers(value);
                    continue block6;
                }
                case ACKS: {
                    builder.acks(value);
                    continue block6;
                }
                case AUDIT_TOPIC: {
                    builder.auditTopic(value);
                    continue block6;
                }
                case CACHE_ENTRIES_TOPIC: {
                    builder.cacheEntriesTopic(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseCacheCloudEvents(XMLExtendedStreamReader reader, CloudEventsConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.enabled(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

