/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cloudevents;

import org.infinispan.cloudevents.configuration.CloudEventsConfiguration;
import org.infinispan.cloudevents.configuration.CloudEventsGlobalConfiguration;
import org.infinispan.cloudevents.impl.EntryEventListener;
import org.infinispan.cloudevents.impl.KafkaEventSender;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Experimental;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.DynamicModuleMetadataProvider;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.lifecycle.ModuleLifecycle;

@Experimental
@InfinispanModule(name="cloudevents", requiredModules={"core"})
public final class CloudEventsModule
implements ModuleLifecycle,
DynamicModuleMetadataProvider {
    public static final String CLOUDEVENTS_FEATURE = "cloudevents";
    private GlobalConfiguration globalConfiguration;
    private CloudEventsGlobalConfiguration cloudEventsGlobalConfiguration;

    public void registerDynamicMetadata(ModuleMetadataBuilder.ModuleBuilder moduleBuilder, GlobalConfiguration globalConfiguration) {
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
        this.cloudEventsGlobalConfiguration = (CloudEventsGlobalConfiguration)globalConfiguration.module(CloudEventsGlobalConfiguration.class);
        if (this.cloudEventsGlobalConfiguration == null) {
            return;
        }
        if (!this.cloudEventsGlobalConfiguration.cacheEntryEventsEnabled() && !this.cloudEventsGlobalConfiguration.auditEventsEnabled()) {
            return;
        }
        if (!globalConfiguration.features().isAvailable(CLOUDEVENTS_FEATURE)) {
            throw Log.CONFIG.featureDisabled(CLOUDEVENTS_FEATURE);
        }
        gcr.getComponent(KafkaEventSender.class);
    }

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        if (!this.cloudEventsGlobalConfiguration.cacheEntryEventsEnabled()) {
            return;
        }
        CloudEventsConfiguration cloudEventsConfiguration = (CloudEventsConfiguration)configuration.module(CloudEventsConfiguration.class);
        if (cloudEventsConfiguration != null && !cloudEventsConfiguration.enabled()) {
            return;
        }
        if (!this.globalConfiguration.features().isAvailable(CLOUDEVENTS_FEATURE)) {
            throw Log.CONFIG.featureDisabled(CLOUDEVENTS_FEATURE);
        }
        EntryEventListener listener = new EntryEventListener();
        cr.registerComponent((Object)listener, EntryEventListener.class);
    }
}

