/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cloudevents;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.infinispan.cloudevents.configuration.CloudEventsConfiguration;
import org.infinispan.cloudevents.configuration.CloudEventsGlobalConfiguration;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cloudevents.CloudEventsConfigurationSerializerTest")
@CleanupAfterMethod
public class CloudEventsConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    @DataProvider
    public static Object[][] configurationFiles() {
        return new Object[][]{{Paths.get("config/cloudevents.xml", new String[0])}};
    }

    public void testParser() throws IOException {
        ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("config/cloudevents.xml");
        try (EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager((boolean)false, (ConfigurationBuilderHolder)holder);){
            CloudEventsGlobalConfiguration cloudEventsGlobalConfiguration = (CloudEventsGlobalConfiguration)cacheManager.getCacheManagerConfiguration().module(CloudEventsGlobalConfiguration.class);
            AssertJUnit.assertEquals((String)"127.0.0.1:9092", (String)cloudEventsGlobalConfiguration.bootstrapServers());
            AssertJUnit.assertEquals((String)"0", (String)cloudEventsGlobalConfiguration.acks());
            AssertJUnit.assertEquals((String)"audit", (String)cloudEventsGlobalConfiguration.auditTopic());
            AssertJUnit.assertTrue((boolean)cloudEventsGlobalConfiguration.auditEventsEnabled());
            AssertJUnit.assertEquals((String)"cache-events", (String)cloudEventsGlobalConfiguration.cacheEntriesTopic());
            AssertJUnit.assertTrue((boolean)cloudEventsGlobalConfiguration.cacheEntryEventsEnabled());
            Configuration cache1 = cacheManager.getCacheConfiguration("cache1");
            AssertJUnit.assertNull((Object)cache1.module(CloudEventsConfiguration.class));
            Configuration cache2 = cacheManager.getCacheConfiguration("cache2");
            AssertJUnit.assertFalse((boolean)((CloudEventsConfiguration)cache2.module(CloudEventsConfiguration.class)).enabled());
        }
    }

    public void testInvalid() throws IOException {
        ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("config/cloudevents-missing-bootstrap-servers.xml");
        Exceptions.expectException(CacheConfigurationException.class, (String)"ISPN030502: .*", () -> holder.getGlobalConfigurationBuilder().build());
    }

    @Test(dataProvider="configurationFiles")
    public void jsonSerializationTest(Path config) throws Exception {
        throw new SkipException("JSON deserialization doesn't work");
    }

    protected void compareExtraGlobalConfiguration(GlobalConfiguration configurationBefore, GlobalConfiguration configurationAfter) {
        CloudEventsGlobalConfiguration before = (CloudEventsGlobalConfiguration)configurationBefore.module(CloudEventsGlobalConfiguration.class);
        CloudEventsGlobalConfiguration after = (CloudEventsGlobalConfiguration)configurationAfter.module(CloudEventsGlobalConfiguration.class);
        AssertJUnit.assertNotNull((Object)before);
        AssertJUnit.assertNotNull((Object)after);
        AssertJUnit.assertEquals((String)before.bootstrapServers(), (String)after.bootstrapServers());
        AssertJUnit.assertEquals((String)before.auditTopic(), (String)after.auditTopic());
        AssertJUnit.assertEquals((String)before.cacheEntriesTopic(), (String)after.cacheEntriesTopic());
    }

    protected void compareExtraConfiguration(String name, Configuration configurationBefore, Configuration configurationAfter) {
        CloudEventsConfiguration before = (CloudEventsConfiguration)configurationBefore.module(CloudEventsConfiguration.class);
        CloudEventsConfiguration after = (CloudEventsConfiguration)configurationAfter.module(CloudEventsConfiguration.class);
        if (before == null && after == null) {
            return;
        }
        if (before == null || after == null) {
            AssertJUnit.fail((String)("before=" + before + ", after=" + after));
        }
        AssertJUnit.assertEquals((boolean)before.enabled(), (boolean)after.enabled());
    }
}

