/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cloudevents;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.infinispan.cloudevents.impl.KafkaEventSender;
import org.infinispan.cloudevents.impl.Log;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.LogFactory;

public class MockKafkaEventSender
implements KafkaEventSender {
    private static final Log log = (Log)LogFactory.getLog(MockKafkaEventSender.class, Log.class);
    MockProducer<byte[], byte[]> producer = new MockProducer(false, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());

    public CompletionStage<Void> send(ProducerRecord<byte[], byte[]> record) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        this.producer.send(record, (metadata, exception) -> {
            if (exception != null) {
                cf.completeExceptionally(exception);
            } else {
                cf.complete(null);
            }
        });
        return cf;
    }

    public MockProducer<byte[], byte[]> getProducer() {
        return this.producer;
    }

    void clear() {
        this.producer.clear();
    }

    public void completeSend() {
        long deadlineNanos = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        while (!this.producer.completeNext()) {
            if (System.nanoTime() - deadlineNanos > 0L) {
                throw new TimeoutException();
            }
            TestingUtil.sleepThread((long)10L);
        }
        List history = this.getProducer().history();
        log.tracef("Completed send %s", ((ProducerRecord)history.get(history.size() - 1)).key());
    }

    public void completeSend(int count) {
        for (int i = 0; i < count; ++i) {
            this.completeSend();
        }
    }
}

