/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import java.util.EnumSet;
import java.util.Map;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.impl.function.AddFunction;
import org.infinispan.counter.impl.function.CompareAndSwapFunction;
import org.infinispan.counter.impl.function.CreateAndAddFunction;
import org.infinispan.counter.impl.function.CreateAndCASFunction;
import org.infinispan.counter.impl.function.InitializeCounterFunction;
import org.infinispan.counter.impl.function.ReadFunction;
import org.infinispan.counter.impl.function.RemoveFunction;
import org.infinispan.counter.impl.function.ResetFunction;
import org.infinispan.counter.impl.interceptor.CounterInterceptor;
import org.infinispan.counter.impl.listener.CounterKeyFilter;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.counter.impl.metadata.ConfigurationMetadata;
import org.infinispan.counter.impl.persistence.PersistenceContextInitializerImpl;
import org.infinispan.counter.logging.Log;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.LogFactory;

@InfinispanModule(name="clustered-counter", requiredModules={"core"})
public class CounterModuleLifecycle
implements ModuleLifecycle {
    public static final String COUNTER_CACHE_NAME = "org.infinispan.COUNTER";
    private static final Log log = (Log)LogFactory.getLog(CounterModuleLifecycle.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();

    private static Configuration createCounterCacheConfiguration(CounterManagerConfiguration config) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(config.numOwners()).stateTransfer().fetchInMemoryState(true).l1().disable().partitionHandling().whenSplit(config.reliability() == Reliability.CONSISTENT ? PartitionHandling.DENY_READ_WRITES : PartitionHandling.ALLOW_READ_WRITES).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return builder.build();
    }

    private static Configuration createLocalCounterCacheConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.LOCAL).l1().disable().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return builder.build();
    }

    private static void addAdvancedExternalizer(Map<Integer, AdvancedExternalizer<?>> map, AdvancedExternalizer<?> ext) {
        map.put(ext.getId(), ext);
    }

    private static CounterManagerConfiguration extractConfiguration(GlobalConfiguration globalConfiguration) {
        CounterManagerConfiguration config = (CounterManagerConfiguration)globalConfiguration.module(CounterManagerConfiguration.class);
        return config == null ? CounterManagerConfigurationBuilder.defaultConfiguration() : config;
    }

    private static void registerCounterManager(EmbeddedCacheManager cacheManager, BasicComponentRegistry registry) {
        if (trace) {
            log.tracef("Registering counter manager.", new Object[0]);
        }
        EmbeddedCounterManager counterManager = new EmbeddedCounterManager(cacheManager);
        registry.registerComponent(CounterManager.class, (Object)counterManager, true);
        if (cacheManager.getCacheManagerConfiguration().statistics()) {
            CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)registry.getComponent(CacheManagerJmxRegistration.class).running();
            jmxRegistration.registerMBean((Object)counterManager);
        }
    }

    private static void registerCounterCache(InternalCacheRegistry registry, CounterManagerConfiguration config) {
        registry.registerInternalCache(COUNTER_CACHE_NAME, CounterModuleLifecycle.createCounterCacheConfiguration(config), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE, InternalCacheRegistry.Flag.PERSISTENT));
    }

    private static void registerLocalCounterCache(InternalCacheRegistry registry) {
        registry.registerInternalCache(COUNTER_CACHE_NAME, CounterModuleLifecycle.createLocalCounterCacheConfiguration(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE, InternalCacheRegistry.Flag.PERSISTENT));
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        Map externalizerMap = globalConfiguration.serialization().advancedExternalizers();
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, ResetFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CounterKeyFilter.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, ReadFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CounterConfiguration.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, InitializeCounterFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, ConfigurationMetadata.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, AddFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CompareAndSwapFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CreateAndCASFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, CreateAndAddFunction.EXTERNALIZER);
        CounterModuleLifecycle.addAdvancedExternalizer(externalizerMap, RemoveFunction.EXTERNALIZER);
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)bcr.getComponent(EmbeddedCacheManager.class).wired();
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)bcr.getComponent(InternalCacheRegistry.class).running();
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        CounterManagerConfiguration counterManagerConfiguration = CounterModuleLifecycle.extractConfiguration(globalConfiguration);
        if (gcr.getGlobalConfiguration().isClustered()) {
            CounterModuleLifecycle.registerCounterCache(internalCacheRegistry, counterManagerConfiguration);
        } else {
            CounterModuleLifecycle.registerLocalCounterCache(internalCacheRegistry);
        }
        CounterModuleLifecycle.registerCounterManager(cacheManager, bcr);
    }

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        if (COUNTER_CACHE_NAME.equals(cacheName) && configuration.clustering().cacheMode().isClustered()) {
            BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
            CounterInterceptor counterInterceptor = new CounterInterceptor();
            bcr.registerComponent(CounterInterceptor.class, (Object)counterInterceptor, true);
            bcr.addDynamicDependency(AsyncInterceptorChain.class.getName(), CounterInterceptor.class.getName());
            ((AsyncInterceptorChain)bcr.getComponent(AsyncInterceptorChain.class).wired()).addInterceptorAfter((AsyncInterceptor)counterInterceptor, EntryWrappingInterceptor.class);
        }
    }
}

