package org.infinispan.counter.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.util.ByteString;
import org.infinispan.counter.exception.CounterConfigurationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.counter.exception.CounterException;
import java.util.Arrays;
import java.io.File;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-03-16T08:44:27+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String missingCounterName = "ISPN029503: The counter name is missing.";
    protected String missingCounterName$str() {
        return missingCounterName;
    }
    @Override
    public final CounterConfigurationException missingCounterName() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), missingCounterName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStorageMode = "ISPN029504: Invalid storage mode. It must be non-null";
    protected String invalidStorageMode$str() {
        return invalidStorageMode;
    }
    @Override
    public final CounterConfigurationException invalidStorageMode() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidStorageMode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPersistentStorageMode = "ISPN029505: Invalid storage mode. PERSISTENT is not allowed without global state enabled in cache container.";
    protected String invalidPersistentStorageMode$str() {
        return invalidPersistentStorageMode;
    }
    @Override
    public final CounterConfigurationException invalidPersistentStorageMode() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidPersistentStorageMode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumOwners = "ISPN029506: Invalid number of owner. It must be higher than zero but it was %s";
    protected String invalidNumOwners$str() {
        return invalidNumOwners;
    }
    @Override
    public final CounterConfigurationException invalidNumOwners(final int value) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidNumOwners$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidReliabilityMode = "ISPN029507: Invalid reliability mode. It must be non-null";
    protected String invalidReliabilityMode$str() {
        return invalidReliabilityMode;
    }
    @Override
    public final CounterConfigurationException invalidReliabilityMode() {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidReliabilityMode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInitialValueForBoundedCounter = "ISPN029508: Invalid initial value for counter. It must be between %s and %s (inclusive) but was %s";
    protected String invalidInitialValueForBoundedCounter$str() {
        return invalidInitialValueForBoundedCounter;
    }
    @Override
    public final CounterConfigurationException invalidInitialValueForBoundedCounter(final long lower, final long upper, final long value) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidInitialValueForBoundedCounter$str(), lower, upper, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConcurrencyLevel = "ISPN029509: Invalid concurrency-level. It must be higher than zero but it was %s";
    protected String invalidConcurrencyLevel$str() {
        return invalidConcurrencyLevel;
    }
    @Override
    public final CounterConfigurationException invalidConcurrencyLevel(final int value) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidConcurrencyLevel$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCounterType = "ISPN029514: Invalid counter type. Expected=%s but got %s";
    protected String invalidCounterType$str() {
        return invalidCounterType;
    }
    @Override
    public final CounterException invalidCounterType(final String expected, final String actual) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidCounterType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToFetchCaches = "ISPN029515: Unable to fetch counter manager caches.";
    protected String unableToFetchCaches$str() {
        return unableToFetchCaches;
    }
    @Override
    public final CounterException unableToFetchCaches() {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), unableToFetchCaches$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefinedCounter = "ISPN029516: Counter '%s' is not defined.";
    protected String undefinedCounter$str() {
        return undefinedCounter;
    }
    @Override
    public final CounterException undefinedCounter(final String name) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), undefinedCounter$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicatedCounterName = "ISPN029517: Duplicated counter name found. Counter '%s' already exists.";
    protected String duplicatedCounterName$str() {
        return duplicatedCounterName;
    }
    @Override
    public final CounterConfigurationException duplicatedCounterName(final String counter) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), duplicatedCounterName$str(), counter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String metadataIsMissing = "ISPN029518: Metadata not found but counter exists. Counter=%s";
    protected String metadataIsMissing$str() {
        return metadataIsMissing;
    }
    @Override
    public final IllegalStateException metadataIsMissing(final ByteString counterName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), metadataIsMissing$str(), counterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScope = "ISPN029520: Invalid scope for tag <counter>. Expected CACHE_CONTAINER but was %s";
    protected String invalidScope$str() {
        return invalidScope;
    }
    @Override
    public final CounterConfigurationException invalidScope(final String scope) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidScope$str(), scope));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSameLowerAndUpperBound = "ISPN029524: Lower bound (%s) and upper bound (%s) can't be the same.";
    protected String invalidSameLowerAndUpperBound$str() {
        return invalidSameLowerAndUpperBound;
    }
    @Override
    public final CounterConfigurationException invalidSameLowerAndUpperBound(final long lower, final long upper) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), invalidSameLowerAndUpperBound$str(), lower, upper));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRenamePersistentFile = "ISPN029525: Cannot rename file %s to %s";
    protected String cannotRenamePersistentFile$str() {
        return cannotRenamePersistentFile;
    }
    @Override
    public final CounterConfigurationException cannotRenamePersistentFile(final String absolutePath, final File persistentFile, final Throwable cause) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), cannotRenamePersistentFile$str(), absolutePath, persistentFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorPersistingCountersConfiguration = "ISPN029526: Error while persisting counter's configurations";
    protected String errorPersistingCountersConfiguration$str() {
        return errorPersistingCountersConfiguration;
    }
    @Override
    public final CounterConfigurationException errorPersistingCountersConfiguration(final Throwable cause) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), errorPersistingCountersConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorReadingCountersConfiguration = "ISPN029527: Error while reading counter's configurations";
    protected String errorReadingCountersConfiguration$str() {
        return errorReadingCountersConfiguration;
    }
    @Override
    public final CounterConfigurationException errorReadingCountersConfiguration(final Throwable cause) {
        final CounterConfigurationException result = new CounterConfigurationException(String.format(getLoggingLocale(), errorReadingCountersConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managerNotStarted = "ISPN029528: CounterManager hasn't started yet or has been stopped.";
    protected String managerNotStarted$str() {
        return managerNotStarted;
    }
    @Override
    public final CounterException managerNotStarted() {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), managerNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jmxRegistrationFailed = "ISPN029529: MBean registration failed";
    protected String jmxRegistrationFailed$str() {
        return jmxRegistrationFailed;
    }
    @Override
    public final CounterException jmxRegistrationFailed(final Throwable cause) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), jmxRegistrationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
