/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.util;

import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.util.TestCounter;

public class WeakTestCounter
implements TestCounter {
    private final SyncWeakCounter syncCounter;
    private final WeakCounter counter;

    public WeakTestCounter(WeakCounter counter) {
        this.counter = counter;
        this.syncCounter = counter.sync();
    }

    @Override
    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.counter.addListener(listener);
    }

    @Override
    public void increment() {
        this.syncCounter.increment();
    }

    @Override
    public void add(long delta) {
        this.syncCounter.add(delta);
    }

    @Override
    public void decrement() {
        this.syncCounter.decrement();
    }

    @Override
    public long getValue() {
        return this.syncCounter.getValue();
    }

    @Override
    public void reset() {
        this.syncCounter.reset();
    }

    @Override
    public String getName() {
        return this.syncCounter.getName();
    }

    @Override
    public CounterConfiguration getConfiguration() {
        return this.syncCounter.getConfiguration();
    }

    @Override
    public boolean isSame(TestCounter other) {
        return other instanceof WeakTestCounter && this.counter == ((WeakTestCounter)other).counter;
    }

    @Override
    public void remove() {
        this.syncCounter.remove();
    }
}

