/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.util.StrongTestCounter;
import org.infinispan.counter.util.TestCounter;
import org.infinispan.counter.util.WeakTestCounter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="counter.CounterStressTest")
public class CounterStressTest
extends MultipleCacheManagersTest {
    private static final long TEST_DURATION_MILLIS = TimeUnit.MINUTES.toMillis(2L);
    private static final double NANOS_TO_MILLIS = 1.0E-6;
    private static final double MILLIS_TO_SEC = 0.001;
    private static final int CLUSTER_SIZE = 8;
    private Reports report;

    private static double[] awaitResults(List<Future<Long>> results) throws ExecutionException, InterruptedException {
        double[] millis = new double[results.size()];
        int idx = 0;
        for (Future<Long> result : results) {
            millis[idx++] = (double)result.get().longValue() * 1.0E-6;
        }
        return millis;
    }

    private static void printRow(int threads, Result result) {
        double sum = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (double d : result.millis) {
            sum += d;
            min = Math.min(d, min);
            max = Math.max(d, max);
        }
        System.out.printf("%d | %s |", threads, result.factoryName);
        double avg = sum / (double)result.millis.length;
        System.out.printf("avg=%,.2f, min=%,.2f, max=%,.2f |", avg, min, max);
        double avgSec = avg * 0.001;
        System.out.printf("%,.2f%n", (double)result.operations / avgSec);
    }

    @BeforeClass(alwaysRun=true)
    public void init() {
        this.report = new Reports();
    }

    @AfterClass(alwaysRun=true)
    public void report() {
        this.report.printReport();
    }

    @Test(dataProvider="threads")
    public void stress(int threadsPerNode, TestCounterFactory factory) throws ExecutionException, InterruptedException {
        int c;
        int threads = threadsPerNode * 8;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ArrayList<Future<Long>> results = new ArrayList<Future<Long>>(threads);
        String counterName = String.format("%s_%d", factory.factoryName(), threadsPerNode);
        AtomicBoolean stop = new AtomicBoolean(false);
        System.out.println("== STRESS TEST STARTED ==");
        System.out.printf("Factory='%s'%nThreads/Node=%d%nCluster=%d%nCounter name='%s'%n", factory.factoryName(), threadsPerNode, 8, counterName);
        for (int c2 = 0; c2 < 8; ++c2) {
            TestCounter counter = factory.getCounter(this.manager(c2), counterName);
            for (int t = 0; t < threadsPerNode; ++t) {
                results.add(this.fork(new StressCallable(counter, barrier, stop)));
            }
        }
        System.out.printf("== THREADS CREATED (%d/%d) ==%n", results.size(), threads);
        Thread.sleep(TEST_DURATION_MILLIS);
        stop.set(true);
        double[] millis = CounterStressTest.awaitResults(results);
        System.out.println("== STRESS TEST FINISHED ==");
        long[] countersValues = new long[8];
        for (c = 0; c < 8; ++c) {
            countersValues[c] = factory.getCounter(this.manager(c), counterName).getValue();
        }
        this.report.add(threads, factory, millis, countersValues[0]);
        for (c = 1; c < 8; ++c) {
            AssertJUnit.assertEquals((String)("StrongCounter mismatch for manager " + c), (long)countersValues[0], (long)countersValues[c]);
        }
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = CounterStressTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        builder.clustering().hash().numOwners(2);
        this.createClusteredCaches(8, builder);
    }

    @DataProvider(name="threads")
    private Object[][] threadPerNode() {
        return new Object[][]{{2, Factories.ATOMIC}, {2, Factories.THRESHOLD}, {2, Factories.WEAK}, {4, Factories.ATOMIC}, {4, Factories.THRESHOLD}, {4, Factories.WEAK}, {8, Factories.ATOMIC}, {8, Factories.THRESHOLD}, {8, Factories.WEAK}, {16, Factories.ATOMIC}, {16, Factories.THRESHOLD}, {16, Factories.WEAK}};
    }

    private class StressCallable
    implements Callable<Long> {
        private final TestCounter counter;
        private final CyclicBarrier barrier;
        private final AtomicBoolean stop;

        private StressCallable(TestCounter counter, CyclicBarrier barrier, AtomicBoolean stop) {
            this.counter = counter;
            this.barrier = barrier;
            this.stop = stop;
        }

        @Override
        public Long call() throws Exception {
            try {
                this.barrier.await();
                long start = System.nanoTime();
                while (!this.stop.get()) {
                    try {
                        this.counter.increment();
                    }
                    catch (Exception e) {
                        CounterStressTest.this.log.error((Object)"Error incrementing counter.", (Throwable)e);
                    }
                }
                long end = System.nanoTime();
                this.barrier.await();
                return end - start;
            }
            catch (Exception e) {
                CounterStressTest.this.log.error((Object)"Unexpected Exception", (Throwable)e);
                throw e;
            }
        }
    }

    private static class Result {
        private final String factoryName;
        private final double[] millis;
        private final long operations;

        private Result(String factoryName, double[] millis, long operations) {
            this.factoryName = factoryName;
            this.millis = millis;
            this.operations = operations;
        }
    }

    private static class Reports {
        private final Map<Integer, List<Result>> reports = new HashMap<Integer, List<Result>>();

        private Reports() {
        }

        void add(int threads, TestCounterFactory factory, double[] rawResultsMillis, long operations) {
            List resultList = this.reports.computeIfAbsent(threads, t -> new ArrayList(3));
            resultList.add(new Result(factory.factoryName(), rawResultsMillis, operations));
        }

        void printReport() {
            System.out.println("== RESULTS ==");
            System.out.println("Threads | Factory | Total Time (ms) | Throughput (op/sec)");
            for (Map.Entry<Integer, List<Result>> entry : this.reports.entrySet()) {
                int threads = entry.getKey();
                List<Result> results = entry.getValue();
                for (Result result : results) {
                    CounterStressTest.printRow(threads, result);
                }
            }
            System.out.println("== RESULTS ==");
        }
    }

    private static interface TestCounterFactory {
        public TestCounter getCounter(EmbeddedCacheManager var1, String var2);

        public String factoryName();
    }

    private static enum Factories implements TestCounterFactory
    {
        ATOMIC{

            @Override
            public TestCounter getCounter(EmbeddedCacheManager manager, String counterName) {
                CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)manager);
                counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
                return new StrongTestCounter(counterManager.getStrongCounter(counterName));
            }
        }
        ,
        THRESHOLD{

            @Override
            public TestCounter getCounter(EmbeddedCacheManager manager, String counterName) {
                CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)manager);
                counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).upperBound(Long.MAX_VALUE).lowerBound(Long.MIN_VALUE).build());
                return new StrongTestCounter(counterManager.getStrongCounter(counterName));
            }
        }
        ,
        WEAK{

            @Override
            public TestCounter getCounter(EmbeddedCacheManager manager, String counterName) {
                CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)manager);
                counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.WEAK).build());
                return new WeakTestCounter(EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)manager).getWeakCounter(counterName));
            }
        };


        @Override
        public String factoryName() {
            return this.name();
        }
    }
}

