/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.impl.BaseCounterTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.RestartCounterTest")
@CleanupAfterMethod
public class RestartCounterTest
extends BaseCounterTest {
    private static final String PERSISTENT_FOLDER = CommonsTestingUtil.tmpDirectory((String)RestartCounterTest.class.getSimpleName());
    private static final String TEMP_PERSISTENT_FOLDER = PERSISTENT_FOLDER + File.separator + "temp";
    private static final String SHARED_PERSISTENT_FOLDER = PERSISTENT_FOLDER + File.separator + "shared";
    private static final int CLUSTER_SIZE = 4;
    private final Collection<CounterDefinition> defaultCounters = new ArrayList<CounterDefinition>(6);
    private final Collection<CounterDefinition> otherCounters = new ArrayList<CounterDefinition>(6);

    public RestartCounterTest() {
        this.defaultCounters.add(new CounterDefinition("v-bounded", CounterType.BOUNDED_STRONG, Storage.VOLATILE));
        this.defaultCounters.add(new CounterDefinition("p-bounded", CounterType.BOUNDED_STRONG, Storage.PERSISTENT));
        this.defaultCounters.add(new CounterDefinition("v-unbounded", CounterType.UNBOUNDED_STRONG, Storage.VOLATILE));
        this.defaultCounters.add(new CounterDefinition("p-unbounded", CounterType.UNBOUNDED_STRONG, Storage.PERSISTENT));
        this.defaultCounters.add(new CounterDefinition("v-weak", CounterType.WEAK, Storage.VOLATILE));
        this.defaultCounters.add(new CounterDefinition("p-weak", CounterType.WEAK, Storage.PERSISTENT));
        this.otherCounters.add(new CounterDefinition("o-v-bounded", CounterType.BOUNDED_STRONG, Storage.VOLATILE));
        this.otherCounters.add(new CounterDefinition("o-p-bounded", CounterType.BOUNDED_STRONG, Storage.PERSISTENT));
        this.otherCounters.add(new CounterDefinition("o-v-unbounded", CounterType.UNBOUNDED_STRONG, Storage.VOLATILE));
        this.otherCounters.add(new CounterDefinition("o-p-unbounded", CounterType.UNBOUNDED_STRONG, Storage.PERSISTENT));
        this.otherCounters.add(new CounterDefinition("o-v-weak", CounterType.WEAK, Storage.VOLATILE));
        this.otherCounters.add(new CounterDefinition("o-p-weak", CounterType.WEAK, Storage.PERSISTENT));
    }

    private static void incrementAll(Collection<CounterDefinition> counters, CounterManager counterManager) {
        counters.forEach(counterDefinition -> ((CounterDefinition)counterDefinition).incrementCounter(counterManager));
    }

    @AfterMethod(alwaysRun=true)
    public void removeFiles() {
        Util.recursiveFileRemove((String)PERSISTENT_FOLDER);
    }

    public void testCountersInConfiguration() {
        this.assertDefined(this.defaultCounters);
        this.waitForClusterToForm("org.infinispan.COUNTER");
        RestartCounterTest.incrementAll(this.defaultCounters, this.counterManager(0));
        this.assertCounterValue(this.defaultCounters, this.counterManager(0), 1L, 1L);
        this.shutdownAndRestart();
        this.assertDefined(this.defaultCounters);
        this.assertCounterValue(this.defaultCounters, this.counterManager(0), 0L, 1L);
        RestartCounterTest.incrementAll(this.defaultCounters, this.counterManager(0));
        this.assertCounterValue(this.defaultCounters, this.counterManager(0), 1L, 2L);
    }

    public void testRuntimeCounters() {
        CounterManager counterManager = this.counterManager(0);
        this.waitForClusterToForm("org.infinispan.COUNTER");
        RestartCounterTest.incrementAll(this.defaultCounters, counterManager);
        RestartCounterTest.incrementAll(this.defaultCounters, counterManager);
        this.otherCounters.forEach(counterDefinition -> ((CounterDefinition)counterDefinition).define(counterManager));
        RestartCounterTest.incrementAll(this.otherCounters, counterManager);
        this.assertCounterValue(this.defaultCounters, counterManager, 2L, 2L);
        this.assertCounterValue(this.otherCounters, counterManager, 1L, 1L);
        this.shutdownAndRestart();
        CounterManager counterManager2 = this.counterManager(0);
        Collection othersPersisted = this.otherCounters.stream().filter(counterDefinition -> ((CounterDefinition)counterDefinition).storage == Storage.PERSISTENT).collect(Collectors.toList());
        Collection otherVolatile = this.otherCounters.stream().filter(counterDefinition -> ((CounterDefinition)counterDefinition).storage == Storage.VOLATILE).collect(Collectors.toList());
        this.assertDefined(this.defaultCounters);
        this.assertDefined(othersPersisted);
        this.assertNotDefined(otherVolatile);
        this.assertCounterValue(this.defaultCounters, counterManager2, 0L, 2L);
        this.assertCounterValue(othersPersisted, counterManager2, -1L, 1L);
        RestartCounterTest.incrementAll(this.defaultCounters, counterManager2);
        RestartCounterTest.incrementAll(othersPersisted, counterManager2);
        this.assertCounterValue(this.defaultCounters, counterManager2, 1L, 3L);
        this.assertCounterValue(othersPersisted, counterManager2, -1L, 2L);
    }

    @Override
    protected int clusterSize() {
        return 4;
    }

    @Override
    protected GlobalConfigurationBuilder configure(int nodeId) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.globalState().enable().persistentLocation(PERSISTENT_FOLDER + File.separator + nodeId).temporaryLocation(TEMP_PERSISTENT_FOLDER + File.separator + nodeId).sharedPersistentLocation(SHARED_PERSISTENT_FOLDER + File.separator + nodeId);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        this.defaultCounters.forEach(counterDefinition -> ((CounterDefinition)counterDefinition).define(counterBuilder));
        return builder;
    }

    private void shutdownAndRestart() {
        this.cache(0, "org.infinispan.COUNTER").shutdown();
        this.log.debug((Object)"Shutdown caches");
        this.cacheManagers.forEach(Lifecycle::stop);
        this.cacheManagers.clear();
        this.log.debug((Object)"Restart caches");
        this.createCacheManagers();
    }

    private void assertDefined(Collection<CounterDefinition> counters) {
        for (int i = 0; i < 4; ++i) {
            CounterManager counterManager = this.counterManager(i);
            for (CounterDefinition definition : counters) {
                AssertJUnit.assertTrue((String)("Configuration of " + definition.name + " is missing on manager " + i), (boolean)counterManager.isDefined(definition.name));
            }
        }
    }

    private void assertNotDefined(Collection<CounterDefinition> counters) {
        for (int i = 0; i < 4; ++i) {
            CounterManager counterManager = this.counterManager(i);
            for (CounterDefinition definition : counters) {
                AssertJUnit.assertFalse((String)("Configuration of " + definition.name + " is defined on manager " + i), (boolean)counterManager.isDefined(definition.name));
            }
        }
    }

    private void assertCounterValue(Collection<CounterDefinition> counters, CounterManager counterManager, long volatileValue, long persistentValue) {
        for (CounterDefinition definition : counters) {
            long expect = definition.storage == Storage.VOLATILE ? volatileValue : persistentValue;
            this.eventuallyEquals("Wrong value for counter " + definition.name, expect, () -> definition.getValue(counterManager));
        }
    }

    private static class CounterDefinition {
        private final String name;
        private final CounterType type;
        private final Storage storage;

        private CounterDefinition(String name, CounterType type, Storage storage) {
            this.name = name;
            this.type = type;
            this.storage = storage;
        }

        private void define(CounterManagerConfigurationBuilder builder) {
            switch (this.type) {
                case UNBOUNDED_STRONG: {
                    ((StrongCounterConfigurationBuilder)builder.addStrongCounter().name(this.name)).storage(this.storage);
                    break;
                }
                case BOUNDED_STRONG: {
                    ((StrongCounterConfigurationBuilder)builder.addStrongCounter().name(this.name)).lowerBound(0L).storage(this.storage);
                    break;
                }
                case WEAK: {
                    ((WeakCounterConfigurationBuilder)((WeakCounterConfigurationBuilder)builder.addWeakCounter().name(this.name)).storage(this.storage)).concurrencyLevel(16);
                }
            }
        }

        private void define(CounterManager manager) {
            manager.defineCounter(this.name, CounterConfiguration.builder((CounterType)this.type).lowerBound(0L).storage(this.storage).build());
        }

        private void incrementCounter(CounterManager counterManager) {
            switch (this.type) {
                case UNBOUNDED_STRONG: 
                case BOUNDED_STRONG: {
                    counterManager.getStrongCounter(this.name).sync().incrementAndGet();
                    break;
                }
                case WEAK: {
                    counterManager.getWeakCounter(this.name).sync().increment();
                }
            }
        }

        private long getValue(CounterManager counterManager) {
            switch (this.type) {
                case WEAK: {
                    return counterManager.getWeakCounter(this.name).getValue();
                }
                case UNBOUNDED_STRONG: 
                case BOUNDED_STRONG: {
                    return counterManager.getStrongCounter(this.name).sync().getValue();
                }
            }
            throw new IllegalStateException();
        }
    }
}

