/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.manager;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.impl.Utils;
import org.infinispan.counter.impl.manager.CounterConfigurationStorage;
import org.infinispan.counter.impl.manager.SecurityActions;
import org.infinispan.counter.logging.Log;
import org.infinispan.globalstate.ScopeFilter;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.function.SerializablePredicate;

public class CounterConfigurationManager {
    public static final String COUNTER_SCOPE = "counter";
    private final AtomicBoolean counterCacheStarted = new AtomicBoolean(false);
    private final EmbeddedCacheManager cacheManager;
    private final List<AbstractCounterConfiguration> configuredCounters;
    private final CounterConfigurationStorage storage;
    private volatile AdvancedCache<ScopedState, CounterConfiguration> stateCache;
    private volatile CounterConfigurationListener listener;

    CounterConfigurationManager(EmbeddedCacheManager cacheManager, CounterConfigurationStorage storage) {
        this.cacheManager = cacheManager;
        this.storage = storage;
        GlobalConfiguration globalConfig = SecurityActions.getCacheManagerConfiguration(cacheManager);
        CounterManagerConfiguration counterManagerConfig = (CounterManagerConfiguration)globalConfig.module(CounterManagerConfiguration.class);
        this.configuredCounters = counterManagerConfig == null ? Collections.emptyList() : counterManagerConfig.counters();
    }

    private static ScopedState stateKey(String counterName) {
        return new ScopedState(COUNTER_SCOPE, counterName);
    }

    public void start() {
        this.stateCache = this.cacheManager.getCache("org.infinispan.CONFIG").getAdvancedCache();
        this.listener = new CounterConfigurationListener();
        Map<String, CounterConfiguration> persisted = this.storage.loadAll();
        persisted.forEach((name, cfg) -> this.stateCache.putIfAbsent((Object)CounterConfigurationManager.stateKey(name), cfg));
        this.counterCacheStarted.set(false);
        this.stateCache.addListener((Object)this.listener, (CacheEventFilter)new ScopeFilter(COUNTER_SCOPE), null);
        if (!persisted.isEmpty() || this.stateCache.keySet().stream().anyMatch((SerializablePredicate & Serializable)scopedState -> COUNTER_SCOPE.equals(scopedState.getScope()))) {
            this.startCounterCache();
        }
    }

    public void stop() {
        this.counterCacheStarted.set(true);
        if (this.listener != null && this.stateCache != null) {
            this.stateCache.removeListener((Object)this.listener);
        }
        this.listener = null;
        this.stateCache = null;
    }

    public CompletableFuture<Boolean> defineConfiguration(String name, CounterConfiguration configuration) {
        this.validateConfiguration(configuration);
        return this.checkGlobalConfiguration(name).thenCompose(fileConfig -> {
            if (fileConfig != null) {
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }
            return this.stateCache.putIfAbsentAsync((Object)CounterConfigurationManager.stateKey(name), (Object)configuration).thenCompose(cfg -> {
                if (cfg == null) {
                    BlockingManager blockingManager = (BlockingManager)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(BlockingManager.class);
                    return blockingManager.supplyBlocking(() -> {
                        this.storage.store(name, configuration);
                        return Boolean.TRUE;
                    }, (Object)name);
                }
                return CompletableFutures.completedFalse();
            });
        });
    }

    CompletableFuture<Boolean> removeConfiguration(String name) {
        return this.stateCache.removeAsync((Object)CounterConfigurationManager.stateKey(name)).thenApply(Objects::nonNull);
    }

    public Collection<String> getCounterNames() {
        Collection countersName = (Collection)this.stateCache.keySet().stream().filter((Predicate)new ScopeFilter(COUNTER_SCOPE)).map(ScopedState::getName).collect(CacheCollectors.serializableCollector(Collectors::toSet));
        this.configuredCounters.stream().map(AbstractCounterConfiguration::name).forEach(countersName::add);
        return Collections.unmodifiableCollection(countersName);
    }

    CompletableFuture<CounterConfiguration> getConfiguration(String name) {
        return this.stateCache.getAsync((Object)CounterConfigurationManager.stateKey(name)).thenCompose(existingConfiguration -> {
            if (existingConfiguration == null) {
                return this.checkGlobalConfiguration(name);
            }
            return CompletableFuture.completedFuture(existingConfiguration);
        });
    }

    private CompletableFuture<CounterConfiguration> checkGlobalConfiguration(String name) {
        for (AbstractCounterConfiguration config : this.configuredCounters) {
            if (!config.name().equals(name)) continue;
            CounterConfiguration cConfig = ConvertUtil.parsedConfigToConfig(config);
            return this.stateCache.putIfAbsentAsync((Object)CounterConfigurationManager.stateKey(name), (Object)cConfig).thenApply(configuration -> {
                if (configuration == null) {
                    this.storage.store(name, cConfig);
                    return cConfig;
                }
                return configuration;
            });
        }
        return CompletableFutures.completedNull();
    }

    private void createCounter() {
        if (this.stateCache.getStatus() == ComponentStatus.RUNNING) {
            this.startCounterCache();
        }
    }

    private void validateConfiguration(CounterConfiguration configuration) {
        this.storage.validatePersistence(configuration);
        switch (configuration.type()) {
            case BOUNDED_STRONG: {
                Utils.validateStrongCounterBounds(configuration.lowerBound(), configuration.initialValue(), configuration.upperBound());
                break;
            }
            case WEAK: {
                if (configuration.concurrencyLevel() >= 1) break;
                throw Log.CONTAINER.invalidConcurrencyLevel(configuration.concurrencyLevel());
            }
        }
    }

    private void startCounterCache() {
        if (this.counterCacheStarted.compareAndSet(false, true)) {
            BlockingManager blockingManager = (BlockingManager)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(BlockingManager.class);
            blockingManager.runBlocking(() -> {
                String oldName = Thread.currentThread().getName();
                try {
                    GlobalConfiguration configuration = SecurityActions.getCacheManagerConfiguration(this.cacheManager);
                    String threadName = "CounterCacheStartThread," + configuration.transport().nodeName();
                    SecurityActions.setThreadName(threadName);
                    this.cacheManager.getCache("org.infinispan.COUNTER");
                }
                finally {
                    SecurityActions.setThreadName(oldName);
                }
            }, (Object)"org.infinispan.COUNTER");
        }
    }

    @Listener(observation=Listener.Observation.POST, sync=false)
    private class CounterConfigurationListener {
        private CounterConfigurationListener() {
        }

        @CacheEntryModified
        @CacheEntryCreated
        public void onNewCounterConfiguration(Event<ScopedState, CounterConfiguration> event) {
            CounterConfigurationManager.this.createCounter();
        }
    }
}

