/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.util;

import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.util.TestCounter;

public class StrongTestCounter
implements TestCounter {
    private final SyncStrongCounter syncCounter;
    private final StrongCounter counter;

    public StrongTestCounter(StrongCounter counter) {
        this.counter = counter;
        this.syncCounter = counter.sync();
    }

    @Override
    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.counter.addListener(listener);
    }

    @Override
    public void increment() {
        this.syncCounter.incrementAndGet();
    }

    @Override
    public void add(long delta) {
        this.syncCounter.addAndGet(delta);
    }

    public long addAndGet(long delta) {
        return this.syncCounter.addAndGet(delta);
    }

    @Override
    public void decrement() {
        this.syncCounter.decrementAndGet();
    }

    @Override
    public long getValue() {
        return this.syncCounter.getValue();
    }

    @Override
    public void reset() {
        this.syncCounter.reset();
    }

    @Override
    public String getName() {
        return this.syncCounter.getName();
    }

    @Override
    public CounterConfiguration getConfiguration() {
        return this.syncCounter.getConfiguration();
    }

    @Override
    public boolean isSame(TestCounter other) {
        return other instanceof StrongTestCounter && this.counter == ((StrongTestCounter)other).counter;
    }

    @Override
    public void remove() {
        this.syncCounter.remove();
    }

    public boolean compareAndSet(long expect, long value) {
        return this.syncCounter.compareAndSet(expect, value);
    }

    public long compareAndSwap(long expect, long value) {
        return this.syncCounter.compareAndSwap(expect, value);
    }
}

