/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfiguration;

public class CounterConfigurationSerializer
implements ConfigurationSerializer<CounterManagerConfiguration> {
    public void serialize(ConfigurationWriter writer, CounterManagerConfiguration configuration) {
        writer.writeStartListElement((Enum)Element.COUNTERS, true);
        writer.writeDefaultNamespace("urn:infinispan:config:counters:" + Version.getMajorMinor());
        configuration.attributes().write(writer);
        this.writeConfigurations(writer, configuration.counters());
        writer.writeEndListElement();
    }

    public void serializeConfigurations(OutputStream os, List<AbstractCounterConfiguration> configs) {
        BufferedOutputStream output = new BufferedOutputStream(os);
        ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)output).build();
        writer.writeStartDocument();
        writer.writeStartElement((Enum)Element.COUNTERS);
        this.writeConfigurations(writer, configs);
        writer.writeEndElement();
        writer.writeEndDocument();
        Util.close((AutoCloseable)writer);
    }

    private void writeConfigurations(ConfigurationWriter writer, List<AbstractCounterConfiguration> configs) {
        for (AbstractCounterConfiguration c : configs) {
            if (c instanceof StrongCounterConfiguration) {
                this.writeStrongConfiguration((StrongCounterConfiguration)c, writer);
                continue;
            }
            if (!(c instanceof WeakCounterConfiguration)) continue;
            this.writeWeakConfiguration((WeakCounterConfiguration)c, writer);
        }
    }

    private void writeWeakConfiguration(WeakCounterConfiguration configuration, ConfigurationWriter writer) {
        writer.writeStartElement((Enum)Element.WEAK_COUNTER);
        configuration.attributes().write(writer);
        writer.writeEndElement();
    }

    private void writeStrongConfiguration(StrongCounterConfiguration configuration, ConfigurationWriter writer) {
        writer.writeStartElement((Enum)Element.STRONG_COUNTER);
        configuration.attributes().write(writer);
        writer.writeEndElement();
    }
}

