/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.nio.file.Paths;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="counter.ConfigurationTest")
public class ConfigurationTest
extends AbstractCacheTest {
    private static final String PERSISTENT_FOLDER = CommonsTestingUtil.tmpDirectory((String[])new String[]{ConfigurationTest.class.getSimpleName()});
    private static final String TEMP_PERSISTENT_FOLDER = Paths.get(PERSISTENT_FOLDER, "temp").toString();
    private static final String SHARED_PERSISTENT_FOLDER = Paths.get(PERSISTENT_FOLDER, "shared").toString();

    private static GlobalConfigurationBuilder defaultGlobalConfigurationBuilder(boolean globalStateEnabled) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.globalState().enabled(globalStateEnabled).persistentLocation(PERSISTENT_FOLDER).temporaryLocation(TEMP_PERSISTENT_FOLDER).sharedPersistentLocation(SHARED_PERSISTENT_FOLDER);
        return builder;
    }

    private static void assertCounterAndCacheConfiguration(CounterManagerConfiguration config, Configuration cacheConfig) {
        AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)cacheConfig.clustering().cacheMode());
        AssertJUnit.assertEquals((int)config.numOwners(), (int)cacheConfig.clustering().hash().numOwners());
        AssertJUnit.assertEquals((config.reliability() == Reliability.CONSISTENT ? 1 : 0) != 0, (cacheConfig.clustering().partitionHandling().whenSplit() == PartitionHandling.DENY_READ_WRITES ? 1 : 0) != 0);
        AssertJUnit.assertFalse((boolean)cacheConfig.clustering().l1().enabled());
        AssertJUnit.assertEquals((Object)TransactionMode.NON_TRANSACTIONAL, (Object)cacheConfig.transaction().transactionMode());
    }

    @AfterMethod(alwaysRun=true)
    public void removeFiles() {
        Util.recursiveFileRemove((String)PERSISTENT_FOLDER);
        Util.recursiveFileRemove((String)TEMP_PERSISTENT_FOLDER);
        Util.recursiveFileRemove((String)SHARED_PERSISTENT_FOLDER);
    }

    private static Configuration getCounterCacheConfiguration(EmbeddedCacheManager cacheManager) {
        return cacheManager.getCache("org.infinispan.COUNTER").getCacheConfiguration();
    }

    private static EmbeddedCacheManager buildCacheManager(GlobalConfigurationBuilder builder) {
        DefaultCacheManager cacheManager = new DefaultCacheManager(builder.build());
        EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager).isDefined("some-counter");
        return cacheManager;
    }

    public void testDefaultConfiguration() {
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(ConfigurationTest.defaultGlobalConfigurationBuilder(false)), cacheManager -> {
            CounterManagerConfiguration configuration = CounterManagerConfigurationBuilder.defaultConfiguration();
            Configuration cacheConfiguration = ConfigurationTest.getCounterCacheConfiguration(cacheManager);
            ConfigurationTest.assertCounterAndCacheConfiguration(configuration, cacheConfiguration);
        });
    }

    public void testNumOwner() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfiguration config = ((CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class)).numOwner(5).create();
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(builder), cacheManager -> {
            Configuration cacheConfiguration = ConfigurationTest.getCounterCacheConfiguration(cacheManager);
            ConfigurationTest.assertCounterAndCacheConfiguration(config, cacheConfiguration);
        });
    }

    public void testReliability() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfiguration config = ((CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class)).reliability(Reliability.AVAILABLE).create();
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(builder), cacheManager -> {
            Configuration cacheConfiguration = ConfigurationTest.getCounterCacheConfiguration(cacheManager);
            ConfigurationTest.assertCounterAndCacheConfiguration(config, cacheConfiguration);
        });
    }

    public void testReliability2() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfiguration config = ((CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class)).reliability(Reliability.CONSISTENT).create();
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(builder), cacheManager -> {
            Configuration cacheConfiguration = ConfigurationTest.getCounterCacheConfiguration(cacheManager);
            ConfigurationTest.assertCounterAndCacheConfiguration(config, cacheConfiguration);
        });
    }

    public void testInvalidReliability() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        counterBuilder.reliability(Reliability.AVAILABLE);
        builder.build();
        counterBuilder.reliability(Reliability.CONSISTENT);
        builder.build();
        counterBuilder.reliability(null);
        this.assertCounterConfigurationException(builder);
    }

    public void testInvalidNumOwner() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        counterBuilder.numOwner(0);
        this.assertCounterConfigurationException(builder);
        counterBuilder.numOwner(-1);
        this.assertCounterConfigurationException(builder);
        counterBuilder.numOwner(1);
        builder.build();
    }

    public void testDuplicateCounterName() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        counterBuilder.addStrongCounter().name("aCounter");
        counterBuilder.addWeakCounter().name("aCounter");
        this.assertCounterConfigurationException(builder);
        counterBuilder.clearCounters();
        counterBuilder.addStrongCounter().name("aCounter");
        counterBuilder.addStrongCounter().name("aCounter");
        this.assertCounterConfigurationException(builder);
        counterBuilder.clearCounters();
        counterBuilder.addWeakCounter().name("aCounter");
        counterBuilder.addWeakCounter().name("aCounter");
        this.assertCounterConfigurationException(builder);
    }

    public void testMissingCounterName() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        counterBuilder.addStrongCounter();
        this.assertCounterConfigurationException(builder);
        counterBuilder.clearCounters();
        counterBuilder.addWeakCounter();
        this.assertCounterConfigurationException(builder);
    }

    public void testStrongCounterUpperBound() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        ((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("valid")).initialValue(10L)).upperBound(10L);
        builder.build();
        counterBuilder.clearCounters();
        ((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("valid")).initialValue(10L)).upperBound(11L);
        builder.build();
        counterBuilder.clearCounters();
        ((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("invalid")).initialValue(10L)).upperBound(9L);
        this.assertCounterConfigurationException(builder);
    }

    public void testStringCounterLowerBound() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        ((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("valid")).initialValue(10L)).lowerBound(10L);
        builder.build();
        counterBuilder.clearCounters();
        ((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("valid")).initialValue(10L)).lowerBound(9L);
        builder.build();
        counterBuilder.clearCounters();
        ((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("invalid")).initialValue(10L)).lowerBound(11L);
        this.assertCounterConfigurationException(builder);
    }

    public void testInvalidWeakCounterConcurrencyLevel() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        ((WeakCounterConfigurationBuilder)counterBuilder.addWeakCounter().name("invalid")).concurrencyLevel(0);
        this.assertCounterConfigurationException(builder);
        counterBuilder.clearCounters();
        ((WeakCounterConfigurationBuilder)counterBuilder.addWeakCounter().name("invalid")).concurrencyLevel(-1);
        this.assertCounterConfigurationException(builder);
        counterBuilder.clearCounters();
        ((WeakCounterConfigurationBuilder)counterBuilder.addWeakCounter().name("valid")).concurrencyLevel(1);
        builder.build();
    }

    public void testInvalidStorage() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(true);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        ((WeakCounterConfigurationBuilder)counterBuilder.addWeakCounter().name("valid")).storage(Storage.VOLATILE);
        ((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("valid2")).storage(Storage.PERSISTENT);
        builder.build();
        counterBuilder.clearCounters();
        ((WeakCounterConfigurationBuilder)counterBuilder.addWeakCounter().name("valid")).storage(Storage.PERSISTENT);
        ((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("valid2")).storage(Storage.VOLATILE);
        builder.build();
        counterBuilder.clearCounters();
        ((WeakCounterConfigurationBuilder)counterBuilder.addWeakCounter().name("invalid")).storage(null);
        this.assertCounterConfigurationException(builder);
        counterBuilder.clearCounters();
        ((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("invalid")).storage(null);
        this.assertCounterConfigurationException(builder);
    }

    public void testCounters() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(true);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        ((WeakCounterConfigurationBuilder)((WeakCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("unbounded-strong-1")).initialValue(1L)).storage(Storage.VOLATILE)).addStrongCounter().name("lower-bounded-strong-2")).initialValue(2L)).lowerBound(-10L).storage(Storage.PERSISTENT)).addStrongCounter().name("upper-bounded-strong-3")).initialValue(3L)).upperBound(10L).storage(Storage.VOLATILE)).addStrongCounter().name("bounded-strong-4")).initialValue(4L)).lowerBound(-20L).upperBound(20L).storage(Storage.PERSISTENT)).addWeakCounter().name("weak-5")).initialValue(5L)).concurrencyLevel(10).storage(Storage.VOLATILE);
        GlobalConfiguration config = builder.build();
        CounterManagerConfiguration counterConfig = (CounterManagerConfiguration)config.module(CounterManagerConfiguration.class);
        this.assertUnboundedStrongCounter(counterConfig);
        this.assertBoundedStrongCounter(counterConfig, "lower-bounded-strong-2", 2L, -10L, Long.MAX_VALUE, Storage.PERSISTENT);
        this.assertBoundedStrongCounter(counterConfig, "upper-bounded-strong-3", 3L, Long.MIN_VALUE, 10L, Storage.VOLATILE);
        this.assertBoundedStrongCounter(counterConfig, "bounded-strong-4", 4L, -20L, 20L, Storage.PERSISTENT);
        this.assertWeakCounter(counterConfig);
        TestingUtil.withCacheManager(() -> new DefaultCacheManager(builder.build()), cacheManager -> {
            CounterManager manager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager);
            AssertJUnit.assertTrue((boolean)manager.isDefined("unbounded-strong-1"));
            AssertJUnit.assertTrue((boolean)manager.isDefined("lower-bounded-strong-2"));
            AssertJUnit.assertTrue((boolean)manager.isDefined("upper-bounded-strong-3"));
            AssertJUnit.assertTrue((boolean)manager.isDefined("bounded-strong-4"));
            AssertJUnit.assertTrue((boolean)manager.isDefined("weak-5"));
            AssertJUnit.assertFalse((boolean)manager.isDefined("not-defined-counter"));
        });
    }

    public void testInvalidEqualsUpperAndLowerBound() {
        GlobalConfigurationBuilder builder = ConfigurationTest.defaultGlobalConfigurationBuilder(false);
        CounterManagerConfigurationBuilder counterBuilder = (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class);
        ((StrongCounterConfigurationBuilder)((StrongCounterConfigurationBuilder)counterBuilder.addStrongCounter().name("invalid")).initialValue(10L)).lowerBound(10L).upperBound(10L);
        this.assertCounterConfigurationException(builder);
    }

    public void testInvalidEqualsUpperAndLowerBoundInManager() {
        TestingUtil.withCacheManager(DefaultCacheManager::new, cacheManager -> {
            CounterManager manager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager);
            CounterConfiguration cfg = CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(10L).lowerBound(10L).upperBound(10L).build();
            Exceptions.expectException(CounterConfigurationException.class, () -> manager.defineCounter("invalid", cfg));
        });
    }

    private void assertUnboundedStrongCounter(CounterManagerConfiguration config) {
        for (AbstractCounterConfiguration counterConfig : config.counters().values()) {
            if (!counterConfig.name().equals("unbounded-strong-1")) continue;
            AssertJUnit.assertTrue((boolean)(counterConfig instanceof StrongCounterConfiguration));
            AssertJUnit.assertEquals((long)1L, (long)counterConfig.initialValue());
            AssertJUnit.assertEquals((Object)Storage.VOLATILE, (Object)counterConfig.storage());
            return;
        }
        AssertJUnit.fail();
    }

    private void assertWeakCounter(CounterManagerConfiguration config) {
        for (AbstractCounterConfiguration counterConfig : config.counters().values()) {
            if (!counterConfig.name().equals("weak-5")) continue;
            AssertJUnit.assertTrue((boolean)(counterConfig instanceof WeakCounterConfiguration));
            AssertJUnit.assertEquals((long)5L, (long)counterConfig.initialValue());
            AssertJUnit.assertEquals((Object)Storage.VOLATILE, (Object)counterConfig.storage());
            AssertJUnit.assertEquals((int)10, (int)((WeakCounterConfiguration)counterConfig).concurrencyLevel());
            return;
        }
        AssertJUnit.fail();
    }

    private void assertBoundedStrongCounter(CounterManagerConfiguration config, String name, long initialValue, long min, long max, Storage storage) {
        for (AbstractCounterConfiguration counterConfig : config.counters().values()) {
            if (!counterConfig.name().equals(name)) continue;
            AssertJUnit.assertTrue((boolean)(counterConfig instanceof StrongCounterConfiguration));
            AssertJUnit.assertEquals((long)initialValue, (long)counterConfig.initialValue());
            AssertJUnit.assertEquals((Object)storage, (Object)counterConfig.storage());
            AssertJUnit.assertTrue((boolean)((StrongCounterConfiguration)counterConfig).isBound());
            AssertJUnit.assertEquals((long)min, (long)((StrongCounterConfiguration)counterConfig).lowerBound());
            AssertJUnit.assertEquals((long)max, (long)((StrongCounterConfiguration)counterConfig).upperBound());
            return;
        }
        AssertJUnit.fail();
    }

    private void assertCounterConfigurationException(GlobalConfigurationBuilder builder) {
        try {
            builder.build();
            AssertJUnit.fail((String)"CacheConfigurationExpected");
        }
        catch (CacheConfigurationException | CounterConfigurationException expected) {
            log.trace((Object)"Expected", expected);
        }
    }

    public void testLocalManagerNotStarted() {
        TestingUtil.withCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createCacheManager((boolean)false), cm -> Exceptions.expectException(IllegalLifecycleStateException.class, () -> EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cm)));
    }
}

