/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Schema;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.Attribute;
import org.infinispan.counter.configuration.CounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;

@Namespaces(value={@Namespace(root="weak-counter"), @Namespace(root="strong-counter"), @Namespace(uri="urn:infinispan:config:*", root="weak-counter"), @Namespace(uri="urn:infinispan:config:*", root="strong-counter")})
public class CounterParser
implements ConfigurationParser {
    static final String NAMESPACE = "urn:infinispan:config:counters:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        this.readElement(reader, (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class), Element.forName(reader.getLocalName()), null);
    }

    public void readElement(ConfigurationReader reader, CounterManagerConfigurationBuilder builder, Element element, String name) {
        switch (element) {
            case STRONG_COUNTER: {
                Schema schema = this.getSchema(reader);
                if (!schema.since(10, 0)) {
                    this.parseStrongCounterLegacy(reader, (StrongCounterConfigurationBuilder)builder.addStrongCounter().name(name));
                    break;
                }
                this.parseStrongCounter(reader, (StrongCounterConfigurationBuilder)builder.addStrongCounter().name(name));
                break;
            }
            case WEAK_COUNTER: {
                this.parseWeakCounter(reader, (WeakCounterConfigurationBuilder)builder.addWeakCounter().name(name));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private Schema getSchema(ConfigurationReader reader) {
        String namespaceURI = reader.getNamespace();
        if (namespaceURI == null) {
            return new Schema(NAMESPACE, Integer.parseInt(Version.getMajor()), Integer.parseInt(Version.getMinor()));
        }
        return Schema.fromNamespaceURI((String)namespaceURI);
    }

    private void parseWeakCounter(ConfigurationReader reader, WeakCounterConfigurationBuilder builder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CONCURRENCY_LEVEL: {
                    builder.concurrencyLevel(Integer.parseInt(value));
                    continue block3;
                }
                default: {
                    this.parserCommonCounterAttributes(reader, builder, i, attribute, value);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseStrongCounterLegacy(ConfigurationReader reader, StrongCounterConfigurationBuilder builder) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            this.parserCommonCounterAttributes(reader, builder, i, attribute, value);
        }
        block5: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case UPPER_BOUND: {
                    this.parseUpperBound(reader, builder);
                    continue block5;
                }
                case LOWER_BOUND: {
                    this.parseLowerBound(reader, builder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseUpperBound(ConfigurationReader reader, StrongCounterConfigurationBuilder builder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case VALUE: {
                    builder.upperBound(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseLowerBound(ConfigurationReader reader, StrongCounterConfigurationBuilder builder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case VALUE: {
                    builder.lowerBound(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseStrongCounter(ConfigurationReader reader, StrongCounterConfigurationBuilder builder) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case UPPER_BOUND: {
                    builder.upperBound(Long.parseLong(value));
                    continue block4;
                }
                case LOWER_BOUND: {
                    builder.lowerBound(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    this.parserCommonCounterAttributes(reader, builder, i, attribute, value);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parserCommonCounterAttributes(ConfigurationReader reader, CounterConfigurationBuilder builder, int index, Attribute attribute, String value) {
        switch (attribute) {
            case NAME: {
                break;
            }
            case INITIAL_VALUE: {
                builder.initialValue(Long.parseLong(value));
                break;
            }
            case STORAGE: {
                builder.storage(Storage.valueOf((String)value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)index);
            }
        }
    }
}

