/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.ExpirationStrongCounterTest")
public class ExpirationStrongCounterTest
extends MultipleCacheManagersTest {
    private static final long EXPIRATION_MILLISECONDS = 1000L;
    private final ControlledTimeService timeService = new ControlledTimeService((Object)"expiring-strong-counter");

    public void testUnboundedCounter() {
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).lifespan(1000L).build();
        String counterName = "unbounded-counter";
        CounterManager counterManager = this.counterManager();
        counterManager.defineCounter(counterName, config);
        this.doTest(counterName, -1L);
    }

    public void testBoundedCounter() {
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lifespan(1000L).upperBound(3L).build();
        String counterName = "bounded-counter";
        CounterManager counterManager = this.counterManager();
        counterManager.defineCounter(counterName, config);
        this.doTest(counterName, 3L);
    }

    public void testBoundedCounterNeverReached() {
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lifespan(1000L).upperBound(30L).build();
        String counterName = "bounded-counter-2";
        CounterManager counterManager = this.counterManager();
        counterManager.defineCounter(counterName, config);
        this.doTest(counterName, 30L);
    }

    private void doTest(String counterName, long upperBound) {
        SyncStrongCounter counter = this.counterManager().getStrongCounter(counterName).sync();
        if (upperBound == -1L) {
            this.incrementUnbound(counter, 0L);
        } else {
            this.incrementBound(counter, 0L, upperBound);
        }
        this.timeService.advance(1001L);
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
        if (upperBound == -1L) {
            this.incrementUnbound(counter, 0L);
        } else {
            this.incrementBound(counter, 0L, upperBound);
        }
        this.timeService.advance(999L);
        if (upperBound == -1L) {
            AssertJUnit.assertEquals((long)5L, (long)counter.getValue());
            this.incrementUnbound(counter, 5L);
        } else {
            AssertJUnit.assertEquals((long)Math.min(5L, upperBound), (long)counter.getValue());
            this.incrementBound(counter, Math.min(5L, upperBound), upperBound);
        }
        this.timeService.advance(2L);
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
    }

    private void incrementUnbound(SyncStrongCounter counter, long expectedBaseValue) {
        for (int i = 0; i < 5; ++i) {
            this.incrementAndAssert(counter, expectedBaseValue + (long)i + 1L);
        }
        AssertJUnit.assertEquals((long)(expectedBaseValue + 5L), (long)counter.getValue());
    }

    private void incrementBound(SyncStrongCounter counter, long initialValue, long upperBound) {
        for (int i = 0; i < 5; ++i) {
            if (counter.getValue() == upperBound) {
                Exceptions.expectException(CounterOutOfBoundsException.class, () -> ((SyncStrongCounter)counter).incrementAndGet());
                continue;
            }
            this.incrementAndAssert(counter, initialValue + (long)i + 1L);
        }
    }

    protected void createCacheManagers() throws Throwable {
        this.createCluster(2);
        this.cacheManagers.forEach(m -> TestingUtil.replaceComponent((CacheContainer)m, TimeService.class, (Object)this.timeService, (boolean)true));
    }

    private CounterManager counterManager() {
        return EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.manager(0));
    }

    private void incrementAndAssert(SyncStrongCounter counter, long expectedValue) {
        AssertJUnit.assertEquals((long)expectedValue, (long)counter.incrementAndGet());
    }
}

