/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.counter.configuration.CounterConfigurationParser;
import org.infinispan.counter.configuration.CounterConfigurationSerializer;
import org.infinispan.counter.impl.manager.CounterConfigurationStorage;
import org.infinispan.counter.logging.Log;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;

public class PersistedCounterConfigurationStorage
implements CounterConfigurationStorage {
    private static final Log log = (Log)LogFactory.getLog(PersistedCounterConfigurationStorage.class, Log.class);
    private final Map<String, CounterConfiguration> storage = new ConcurrentHashMap<String, CounterConfiguration>();
    private final CounterConfigurationSerializer serializer = new CounterConfigurationSerializer();
    private final CounterConfigurationParser parser = new CounterConfigurationParser();
    private volatile String sharedDirectory;

    PersistedCounterConfigurationStorage() {
    }

    private static AbstractCounterConfiguration fromEntry(Map.Entry<String, CounterConfiguration> entry) {
        return ConvertUtil.configToParsedConfig(entry.getKey(), entry.getValue());
    }

    @Override
    public Map<String, CounterConfiguration> loadAll() {
        try {
            this.doLoadAll();
        }
        catch (IOException e) {
            throw Log.CONTAINER.errorReadingCountersConfiguration(e);
        }
        return this.storage;
    }

    @Override
    public void store(String name, CounterConfiguration configuration) {
        if (configuration.storage() == Storage.VOLATILE) {
            return;
        }
        this.storage.put(name, configuration);
        try {
            this.doStoreAll();
        }
        catch (IOException e) {
            throw Log.CONTAINER.errorPersistingCountersConfiguration(e);
        }
    }

    @Override
    public void remove(String name) {
        this.storage.remove(name);
    }

    @Override
    public void validatePersistence(CounterConfiguration configuration) {
    }

    @Override
    public void initialize(EmbeddedCacheManager cacheManager) {
        this.sharedDirectory = cacheManager.getCacheManagerConfiguration().globalState().sharedPersistentLocation();
    }

    private void doStoreAll() throws IOException {
        File directory = this.getSharedDirectory();
        File temp = File.createTempFile("counters", null, directory);
        try (FileOutputStream f = new FileOutputStream(temp);){
            this.serializer.serializeConfigurations(f, this.convertToList());
        }
        File persistentFile = this.getPersistentFile();
        try {
            Util.renameTempFile((File)temp, (File)this.getFileLock(), (File)persistentFile);
        }
        catch (Exception e) {
            throw Log.CONTAINER.cannotRenamePersistentFile(temp.getAbsolutePath(), persistentFile, e);
        }
    }

    private void doLoadAll() throws IOException {
        block7: {
            File file = this.getPersistentFile();
            try (FileInputStream fis = new FileInputStream(file);){
                this.convertToMap(this.parser.parseConfigurations(fis));
            }
            catch (FileNotFoundException e) {
                if (!log.isTraceEnabled()) break block7;
                log.tracef("File '%s' does not exist. Skip loading.", file.getAbsolutePath());
            }
        }
    }

    private List<AbstractCounterConfiguration> convertToList() {
        return this.storage.entrySet().stream().map(PersistedCounterConfigurationStorage::fromEntry).collect(Collectors.toList());
    }

    private void convertToMap(Map<String, AbstractCounterConfiguration> configs) {
        configs.forEach((n, c) -> this.storage.put((String)n, ConvertUtil.parsedConfigToConfig(c)));
    }

    private File getSharedDirectory() {
        File directory = new File(this.sharedDirectory);
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            if (log.isTraceEnabled()) {
                log.tracef("Shared directory created? %s", created);
            }
        }
        return directory;
    }

    private File getPersistentFile() {
        return new File(this.sharedDirectory, "counters.xml");
    }

    private File getFileLock() {
        return new File(this.sharedDirectory, "counters.xml.lck");
    }
}

