/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.io.IOException;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfiguration;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.ConfigurationSerializerTest")
@CleanupAfterMethod
public class ConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    public void testParser() throws IOException {
        ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("configs/all/counters.xml");
        GlobalConfiguration globalConfiguration = holder.getGlobalConfigurationBuilder().build();
        CounterManagerConfiguration counterManagerConfiguration = (CounterManagerConfiguration)globalConfiguration.module(CounterManagerConfiguration.class);
        AssertJUnit.assertNotNull((Object)counterManagerConfiguration);
        AssertJUnit.assertEquals((int)3, (int)counterManagerConfiguration.numOwners());
        AssertJUnit.assertEquals((Object)Reliability.CONSISTENT, (Object)counterManagerConfiguration.reliability());
        Map counters = counterManagerConfiguration.counters();
        this.assertStrongCounter("c1", (AbstractCounterConfiguration)counters.get("c1"), 1L, Storage.PERSISTENT, false, Long.MIN_VALUE, Long.MAX_VALUE, -1L);
        this.assertStrongCounter("c2", (AbstractCounterConfiguration)counters.get("c2"), 2L, Storage.VOLATILE, true, 0L, Long.MAX_VALUE, -1L);
        this.assertStrongCounter("c3", (AbstractCounterConfiguration)counters.get("c3"), 3L, Storage.PERSISTENT, true, Long.MIN_VALUE, 5L, 2000L);
        this.assertStrongCounter("c4", (AbstractCounterConfiguration)counters.get("c4"), 4L, Storage.VOLATILE, true, 0L, 10L, 0L);
        this.assertWeakCounter((AbstractCounterConfiguration)counters.get("c5"));
    }

    public void testInvalid() {
        Exceptions.expectException(CacheConfigurationException.class, CounterConfigurationException.class, () -> new ParserRegistry().parseFile("configs/invalid.xml"));
    }

    protected void compareExtraGlobalConfiguration(GlobalConfiguration configurationBefore, GlobalConfiguration configurationAfter) {
        CounterManagerConfiguration configBefore = (CounterManagerConfiguration)configurationBefore.module(CounterManagerConfiguration.class);
        CounterManagerConfiguration configAfter = (CounterManagerConfiguration)configurationAfter.module(CounterManagerConfiguration.class);
        AssertJUnit.assertEquals((int)configBefore.numOwners(), (int)configAfter.numOwners());
        AssertJUnit.assertEquals((Object)configBefore.reliability(), (Object)configAfter.reliability());
        Map counterConfigBefore = configBefore.counters();
        Map counterConfigAfter = configAfter.counters();
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c1"), (AbstractCounterConfiguration)counterConfigAfter.get("c1"));
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c2"), (AbstractCounterConfiguration)counterConfigAfter.get("c2"));
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c3"), (AbstractCounterConfiguration)counterConfigAfter.get("c3"));
        this.assertSameStrongCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c4"), (AbstractCounterConfiguration)counterConfigAfter.get("c4"));
        this.assertSameWeakCounterConfiguration((AbstractCounterConfiguration)counterConfigBefore.get("c5"), (AbstractCounterConfiguration)counterConfigAfter.get("c5"));
    }

    private void assertSameStrongCounterConfiguration(AbstractCounterConfiguration c1, AbstractCounterConfiguration c2) {
        AssertJUnit.assertTrue((boolean)(c1 instanceof StrongCounterConfiguration));
        AssertJUnit.assertTrue((boolean)(c2 instanceof StrongCounterConfiguration));
        AssertJUnit.assertEquals((String)c1.name(), (String)c2.name());
        AssertJUnit.assertEquals((long)c1.initialValue(), (long)c2.initialValue());
        AssertJUnit.assertEquals((Object)c1.storage(), (Object)c2.storage());
        AssertJUnit.assertEquals((boolean)((StrongCounterConfiguration)c1).isBound(), (boolean)((StrongCounterConfiguration)c2).isBound());
        AssertJUnit.assertEquals((long)((StrongCounterConfiguration)c1).lowerBound(), (long)((StrongCounterConfiguration)c2).lowerBound());
        AssertJUnit.assertEquals((long)((StrongCounterConfiguration)c1).upperBound(), (long)((StrongCounterConfiguration)c2).upperBound());
    }

    private void assertSameWeakCounterConfiguration(AbstractCounterConfiguration c1, AbstractCounterConfiguration c2) {
        AssertJUnit.assertTrue((boolean)(c1 instanceof WeakCounterConfiguration));
        AssertJUnit.assertTrue((boolean)(c2 instanceof WeakCounterConfiguration));
        AssertJUnit.assertEquals((String)c1.name(), (String)c2.name());
        AssertJUnit.assertEquals((long)c1.initialValue(), (long)c2.initialValue());
        AssertJUnit.assertEquals((Object)c1.storage(), (Object)c2.storage());
        AssertJUnit.assertEquals((int)((WeakCounterConfiguration)c1).concurrencyLevel(), (int)((WeakCounterConfiguration)c2).concurrencyLevel());
    }

    private void assertWeakCounter(AbstractCounterConfiguration configuration) {
        AssertJUnit.assertTrue((boolean)(configuration instanceof WeakCounterConfiguration));
        AssertJUnit.assertEquals((String)"c5", (String)configuration.name());
        AssertJUnit.assertEquals((long)5L, (long)configuration.initialValue());
        AssertJUnit.assertEquals((Object)Storage.PERSISTENT, (Object)configuration.storage());
        AssertJUnit.assertEquals((int)1, (int)((WeakCounterConfiguration)configuration).concurrencyLevel());
    }

    private void assertStrongCounter(String name, AbstractCounterConfiguration configuration, long initialValue, Storage storage, boolean bound, long lowerBound, long upperBound, long lifespan) {
        AssertJUnit.assertTrue((boolean)(configuration instanceof StrongCounterConfiguration));
        AssertJUnit.assertEquals((String)name, (String)configuration.name());
        AssertJUnit.assertEquals((long)initialValue, (long)configuration.initialValue());
        AssertJUnit.assertEquals((Object)storage, (Object)configuration.storage());
        AssertJUnit.assertEquals((boolean)bound, (boolean)((StrongCounterConfiguration)configuration).isBound());
        AssertJUnit.assertEquals((long)lowerBound, (long)((StrongCounterConfiguration)configuration).lowerBound());
        AssertJUnit.assertEquals((long)upperBound, (long)((StrongCounterConfiguration)configuration).upperBound());
        AssertJUnit.assertEquals((long)lifespan, (long)((StrongCounterConfiguration)configuration).lifespan());
    }
}

