/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.function.BaseFunction;
import org.infinispan.counter.impl.metadata.ConfigurationMetadata;
import org.infinispan.counter.logging.Log;
import org.infinispan.util.ByteString;

public class CompareAndSetFunction<K extends CounterKey>
extends BaseFunction<K, CounterState> {
    public static final AdvancedExternalizer<CompareAndSetFunction> EXTERNALIZER = new Externalizer();
    private static final Log log = (Log)LogFactory.getLog(CompareAndSetFunction.class, Log.class);
    private final long expect;
    private final long value;

    public CompareAndSetFunction(long expect, long value) {
        this.expect = expect;
        this.value = value;
    }

    @Override
    void logCounterNotFound(ByteString counterName) {
        log.noSuchCounterCAS(this.expect, this.value, counterName);
    }

    @Override
    CounterState apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView, ConfigurationMetadata metadata) {
        CounterValue existing = (CounterValue)entryView.get();
        if (this.expect == existing.getValue()) {
            if (metadata.get().type() == CounterType.BOUNDED_STRONG) {
                if (this.value < metadata.get().lowerBound()) {
                    return CounterState.LOWER_BOUND_REACHED;
                }
                if (this.value > metadata.get().upperBound()) {
                    return CounterState.UPPER_BOUND_REACHED;
                }
            }
            entryView.set((Object)CounterValue.newCounterValue(this.value, CounterState.VALID), new MetaParam.Writable[]{metadata});
            return CounterState.VALID;
        }
        return null;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private static class Externalizer
    implements AdvancedExternalizer<CompareAndSetFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends CompareAndSetFunction>> getTypeClasses() {
            return Collections.singleton(CompareAndSetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.CAS_FUNCTION;
        }

        public void writeObject(ObjectOutput output, CompareAndSetFunction object) throws IOException {
            output.writeLong(object.expect);
            output.writeLong(object.value);
        }

        public CompareAndSetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CompareAndSetFunction(input.readLong(), input.readLong());
        }
    }
}

