/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.metadata.ConfigurationMetadata;

public class InitializeCounterFunction<K extends CounterKey>
implements Function<EntryView.ReadWriteEntryView<K, CounterValue>, CounterValue> {
    public static final AdvancedExternalizer<InitializeCounterFunction> EXTERNALIZER = new Externalizer();
    private final CounterConfiguration counterConfiguration;

    public InitializeCounterFunction(CounterConfiguration counterConfiguration) {
        this.counterConfiguration = counterConfiguration;
    }

    @Override
    public CounterValue apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView) {
        Optional currentValue = entryView.find();
        if (currentValue.isPresent()) {
            return (CounterValue)currentValue.get();
        }
        CounterValue newValue = CounterValue.newCounterValue(this.counterConfiguration);
        entryView.set((Object)newValue, new MetaParam.Writable[]{new ConfigurationMetadata(this.counterConfiguration)});
        return newValue;
    }

    public String toString() {
        return "InitializeCounterFunction{counterConfiguration=" + this.counterConfiguration + '}';
    }

    private static class Externalizer
    implements AdvancedExternalizer<InitializeCounterFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, InitializeCounterFunction object) throws IOException {
            CounterConfiguration.EXTERNALIZER.writeObject(output, (Object)object.counterConfiguration);
        }

        public InitializeCounterFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new InitializeCounterFunction((CounterConfiguration)CounterConfiguration.EXTERNALIZER.readObject(input));
        }

        public Set<Class<? extends InitializeCounterFunction>> getTypeClasses() {
            return Collections.singleton(InitializeCounterFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.INITIALIZE_FUNCTION;
        }
    }
}

