/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.counter.AbstractCounterTest;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.util.StrongTestCounter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.StrongCounterTest")
public class StrongCounterTest
extends AbstractCounterTest<StrongTestCounter> {
    private static final int CLUSTER_SIZE = 4;

    public void testUniqueReturnValues(Method method) throws ExecutionException, InterruptedException, TimeoutException {
        ArrayList<Future> workers = new ArrayList<Future>(4);
        String counterName = method.getName();
        CyclicBarrier barrier = new CyclicBarrier(4);
        long counterLimit = 1000L;
        int i = 0;
        while (i < 4) {
            int cmIndex = i++;
            workers.add(this.fork(() -> {
                LinkedList<Long> retValues = new LinkedList<Long>();
                CounterManager manager = this.counterManager(cmIndex);
                StrongTestCounter counter = this.createCounter(manager, counterName, 0L);
                long lastRet = 0L;
                barrier.await();
                while (lastRet < 1000L) {
                    lastRet = counter.addAndGet(1L);
                    retValues.add(lastRet);
                }
                return retValues;
            }));
        }
        HashSet<Long> uniqueValuesCheck = new HashSet<Long>();
        for (Future w : workers) {
            List returnValues = (List)w.get(1L, TimeUnit.MINUTES);
            for (Long l : returnValues) {
                AssertJUnit.assertTrue((String)String.format("Duplicated value %d", l), (boolean)uniqueValuesCheck.add(l));
            }
        }
        for (long l = 1L; l < 1003L; ++l) {
            AssertJUnit.assertTrue((String)String.format("Value %d does not exists!", l), (boolean)uniqueValuesCheck.contains(l));
        }
    }

    public void testCompareAndSet(Method method) {
        int i;
        String counterName = method.getName();
        AbstractCounterTest.TestContext context = new AbstractCounterTest.TestContext(this);
        context.printSeed(counterName);
        long expect = context.random.nextLong();
        long value = context.random.nextLong();
        StrongTestCounter counter = this.createCounter(this.counterManager(0), counterName, expect);
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertTrue((boolean)counter.compareAndSet(expect, value));
            AssertJUnit.assertEquals((long)value, (long)counter.getValue());
            expect = value;
            value = context.random.nextLong();
        }
        for (i = 0; i < 10; ++i) {
            long notExpected = context.random.nextLong();
            while (expect == notExpected) {
                notExpected = context.random.nextLong();
            }
            AssertJUnit.assertFalse((boolean)counter.compareAndSet(notExpected, value));
            AssertJUnit.assertEquals((long)expect, (long)counter.getValue());
        }
    }

    public void testCompareAndSetMaxAndMinLong(Method method) {
        String counterName = method.getName();
        StrongTestCounter counter = this.createCounter(this.counterManager(0), counterName, 0L);
        AssertJUnit.assertFalse((boolean)counter.compareAndSet(-1L, Long.MAX_VALUE));
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
        AssertJUnit.assertTrue((boolean)counter.compareAndSet(0L, Long.MAX_VALUE));
        AssertJUnit.assertEquals((long)Long.MAX_VALUE, (long)counter.getValue());
        counter.reset();
        AssertJUnit.assertFalse((boolean)counter.compareAndSet(-1L, Long.MIN_VALUE));
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
        AssertJUnit.assertTrue((boolean)counter.compareAndSet(0L, Long.MIN_VALUE));
        AssertJUnit.assertEquals((long)Long.MIN_VALUE, (long)counter.getValue());
    }

    @Override
    protected StrongTestCounter createCounter(CounterManager counterManager, String counterName, long initialValue) {
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(initialValue).build());
        return new StrongTestCounter(counterManager.getStrongCounter(counterName));
    }

    @Override
    protected void assertMaxValueAfterMaxValue(StrongTestCounter counter, long delta) {
        AssertJUnit.assertEquals((long)Long.MAX_VALUE, (long)counter.addAndGet(delta));
        AssertJUnit.assertEquals((long)Long.MAX_VALUE, (long)counter.getValue());
    }

    @Override
    protected void addAndAssertResult(StrongTestCounter counter, long delta, long expected) {
        AssertJUnit.assertEquals((String)String.format("Wrong return value after adding %d", delta), (long)expected, (long)counter.addAndGet(delta));
        AssertJUnit.assertEquals((String)"Wrong return value of counter.getNewValue()", (long)expected, (long)counter.getValue());
    }

    @Override
    protected void assertMinValueAfterMinValue(StrongTestCounter counter, long delta) {
        AssertJUnit.assertEquals((long)Long.MIN_VALUE, (long)counter.addAndGet(delta));
        AssertJUnit.assertEquals((long)Long.MIN_VALUE, (long)counter.getValue());
    }

    @Override
    protected int clusterSize() {
        return 4;
    }
}

