/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.BaseCounterTest;
import org.infinispan.counter.impl.weak.WeakCounterImpl;
import org.infinispan.counter.impl.weak.WeakCounterKey;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.WeakCounterKeyDistributionTest")
@CleanupAfterMethod
public class WeakCounterKeyDistributionTest
extends BaseCounterTest {
    private static final int CLUSTER_SIZE = 4;

    private static void assertKeyDistribution(Cache<?, ?> cache, String counterName) {
        WeakCounterImpl counter = WeakCounterKeyDistributionTest.getCounter(cache.getCacheManager(), counterName);
        DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
        Address cacheAddress = cache.getAdvancedCache().getRpcManager().getAddress();
        HashSet<WeakCounterKey> preferredKeys = new HashSet<WeakCounterKey>();
        WeakCounterKey[] keys = counter.getPreferredKeys();
        if (keys != null) {
            for (WeakCounterKey key : keys) {
                AssertJUnit.assertTrue((boolean)distributionManager.getPrimaryLocation((Object)key).equals(cacheAddress));
                AssertJUnit.assertTrue((boolean)preferredKeys.add(key));
            }
        }
        for (WeakCounterKey key : counter.getKeys()) {
            if (preferredKeys.remove(key)) continue;
            AssertJUnit.assertFalse((boolean)distributionManager.getPrimaryLocation((Object)key).equals(cacheAddress));
        }
        AssertJUnit.assertTrue((boolean)preferredKeys.isEmpty());
    }

    private static WeakCounterImpl getCounter(EmbeddedCacheManager manager, String counterName) {
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)manager);
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.WEAK).concurrencyLevel(128).build());
        return (WeakCounterImpl)counterManager.getWeakCounter(counterName);
    }

    public void testKeyDistribution(Method method) {
        String counterName = method.getName();
        this.assertKeyDistributionInAllManagers(counterName);
    }

    public void testKeyDistributionAfterJoin(Method method) {
        String counterName = method.getName();
        this.assertKeyDistributionInAllManagers(counterName);
        this.addClusterEnabledCacheManager(this.configure(this.cacheManagers.size()), WeakCounterKeyDistributionTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
        this.waitForCounterCaches();
        this.assertKeyDistributionInAllManagers(counterName);
    }

    public void testKeyDistributionAfterLeave(Method method) {
        String counterName = method.getName();
        this.assertKeyDistributionInAllManagers(counterName);
        this.killMember(1);
        this.waitForCounterCaches();
        this.assertKeyDistributionInAllManagers(counterName);
    }

    @Override
    protected int clusterSize() {
        return 4;
    }

    private void assertKeyDistributionInAllManagers(String counterName) {
        for (EmbeddedCacheManager manager : this.getCacheManagers()) {
            WeakCounterKeyDistributionTest.assertKeyDistribution(manager.getCache("___counters"), counterName);
        }
    }
}

