/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.util.Objects;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.util.Utils;

public class SyncWeakCounter {
    private final WeakCounter counter;

    public SyncWeakCounter(WeakCounter counter) {
        this.counter = Objects.requireNonNull(counter);
    }

    public String getName() {
        return this.counter.getName();
    }

    public long getValue() {
        return this.counter.getValue();
    }

    public void increment() {
        Utils.awaitCounterOperation(this.counter.increment());
    }

    public void decrement() {
        Utils.awaitCounterOperation(this.counter.decrement());
    }

    public void add(long delta) {
        Utils.awaitCounterOperation(this.counter.add(delta));
    }

    public void reset() {
        Utils.awaitCounterOperation(this.counter.reset());
    }

    public String toString() {
        return "SyncWeakCounter{counter=" + this.counter + '}';
    }
}

