/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.function.BaseFunction;
import org.infinispan.counter.impl.metadata.ConfigurationMetadata;
import org.infinispan.counter.logging.Log;
import org.infinispan.util.ByteString;

public final class AddFunction<K extends CounterKey>
extends BaseFunction<K, CounterValue> {
    public static final AdvancedExternalizer<AddFunction> EXTERNALIZER = new Externalizer();
    private static final Log log = (Log)LogFactory.getLog(AddFunction.class, Log.class);
    private final long delta;

    public AddFunction(long delta) {
        this.delta = delta;
    }

    @Override
    void logCounterNotFound(ByteString counterName) {
        log.noSuchCounterAdd(this.delta, counterName);
    }

    @Override
    CounterValue apply(EntryView.ReadWriteEntryView<K, CounterValue> entry, ConfigurationMetadata metadata) {
        if (this.delta == 0L) {
            return (CounterValue)entry.get();
        }
        if (metadata.get().type() == CounterType.BOUNDED_STRONG) {
            if (this.delta > 0L) {
                return this.addAndCheckUpperBound(entry, metadata);
            }
            return this.addAndCheckLowerBound(entry, metadata);
        }
        return this.addUnbounded(entry, metadata);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private CounterValue addUnbounded(EntryView.ReadWriteEntryView<K, CounterValue> entry, ConfigurationMetadata configurationMetadata) {
        CounterValue newValue;
        CounterValue currentValue = (CounterValue)entry.get();
        if (this.noChange(currentValue.getValue())) {
            return currentValue;
        }
        try {
            newValue = CounterValue.newCounterValue(Math.addExact(currentValue.getValue(), this.delta));
        }
        catch (ArithmeticException e) {
            newValue = CounterValue.newCounterValue(this.delta > 0L ? Long.MAX_VALUE : Long.MIN_VALUE);
        }
        entry.set((Object)newValue, new MetaParam.Writable[]{configurationMetadata});
        return newValue;
    }

    private CounterValue addAndCheckLowerBound(EntryView.ReadWriteEntryView<K, CounterValue> entry, ConfigurationMetadata metadata) {
        CounterValue newValue;
        CounterValue currentValue = (CounterValue)entry.get();
        if (currentValue.getState() == CounterState.LOWER_BOUND_REACHED) {
            return currentValue;
        }
        long lowerBound = metadata.get().lowerBound();
        try {
            long addedValue = Math.addExact(currentValue.getValue(), this.delta);
            newValue = addedValue < lowerBound ? CounterValue.newCounterValue(lowerBound, CounterState.LOWER_BOUND_REACHED) : CounterValue.newCounterValue(addedValue, CounterState.VALID);
        }
        catch (ArithmeticException e) {
            newValue = CounterValue.newCounterValue(Long.MIN_VALUE, CounterState.LOWER_BOUND_REACHED);
        }
        entry.set((Object)newValue, new MetaParam.Writable[]{metadata});
        return newValue;
    }

    private CounterValue addAndCheckUpperBound(EntryView.ReadWriteEntryView<K, CounterValue> entry, ConfigurationMetadata metadata) {
        CounterValue newValue;
        CounterValue currentValue = (CounterValue)entry.get();
        if (currentValue.getState() == CounterState.UPPER_BOUND_REACHED) {
            return currentValue;
        }
        long upperBound = metadata.get().upperBound();
        try {
            long addedValue = Math.addExact(currentValue.getValue(), this.delta);
            newValue = addedValue > upperBound ? CounterValue.newCounterValue(upperBound, CounterState.UPPER_BOUND_REACHED) : CounterValue.newCounterValue(addedValue, CounterState.VALID);
        }
        catch (ArithmeticException e) {
            newValue = CounterValue.newCounterValue(Long.MAX_VALUE, CounterState.UPPER_BOUND_REACHED);
        }
        entry.set((Object)newValue, new MetaParam.Writable[]{metadata});
        return newValue;
    }

    private boolean noChange(long currentValue) {
        return currentValue == Long.MAX_VALUE && this.delta > 0L || currentValue == Long.MIN_VALUE && this.delta < 0L;
    }

    private static class Externalizer
    implements AdvancedExternalizer<AddFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends AddFunction>> getTypeClasses() {
            return Collections.singleton(AddFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.ADD_FUNCTION;
        }

        public void writeObject(ObjectOutput output, AddFunction object) throws IOException {
            output.writeLong(object.delta);
        }

        public AddFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new AddFunction(input.readLong());
        }
    }
}

