/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.util;

import org.infinispan.counter.SyncStrongCounter;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.util.TestCounter;

public class StrongTestCounter
implements TestCounter {
    private final SyncStrongCounter syncCounter;
    private final StrongCounter counter;

    public StrongTestCounter(StrongCounter counter) {
        this.counter = counter;
        this.syncCounter = new SyncStrongCounter(counter);
    }

    @Override
    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.counter.addListener(listener);
    }

    @Override
    public void increment() {
        this.syncCounter.incrementAndGet();
    }

    @Override
    public void add(long delta) {
        this.syncCounter.addAndGet(delta);
    }

    public long addAndGet(long delta) {
        return this.syncCounter.addAndGet(delta);
    }

    @Override
    public void decrement() {
        this.syncCounter.decrementAndGet();
    }

    @Override
    public long getValue() {
        return this.syncCounter.getValue();
    }

    @Override
    public void reset() {
        this.syncCounter.reset();
    }

    public boolean compareAndSet(long expect, long value) {
        return this.syncCounter.compareAndSet(expect, value);
    }
}

