/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.util.Objects;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.util.Utils;

public class SyncStrongCounter {
    private final StrongCounter counter;

    public SyncStrongCounter(StrongCounter counter) {
        this.counter = Objects.requireNonNull(counter);
    }

    public long incrementAndGet() {
        return (Long)Utils.awaitCounterOperation(this.counter.incrementAndGet());
    }

    public long decrementAndGet() {
        return (Long)Utils.awaitCounterOperation(this.counter.decrementAndGet());
    }

    public long addAndGet(long delta) {
        return (Long)Utils.awaitCounterOperation(this.counter.addAndGet(delta));
    }

    public void reset() {
        Utils.awaitCounterOperation(this.counter.reset());
    }

    public long getValue() {
        return (Long)Utils.awaitCounterOperation(this.counter.getValue());
    }

    public boolean compareAndSet(long expect, long update) {
        return (Boolean)Utils.awaitCounterOperation(this.counter.compareAndSet(expect, update));
    }

    public String getName() {
        return this.counter.getName();
    }

    public String toString() {
        return "SyncStrongCounter{counter=" + this.counter + '}';
    }
}

