/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.weak;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.function.AddFunction;
import org.infinispan.counter.impl.function.InitializeCounterFunction;
import org.infinispan.counter.impl.function.ResetFunction;
import org.infinispan.counter.impl.listener.CounterEventImpl;
import org.infinispan.counter.impl.listener.CounterFilterAndConvert;
import org.infinispan.counter.impl.listener.NotificationManager;
import org.infinispan.counter.impl.weak.WeakCounterKey;
import org.infinispan.counter.logging.Log;
import org.infinispan.counter.util.Utils;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;

@Listener(clustered=true, observation=Listener.Observation.POST, sync=true)
public class WeakCounterImpl
implements WeakCounter {
    private static final Log log = (Log)LogFactory.getLog(WeakCounterImpl.class, Log.class);
    private static final AtomicReferenceFieldUpdater<Entry, CounterValue> L1_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Entry.class, CounterValue.class, "snapshot");
    private final Entry[] entries;
    private final AdvancedCache<WeakCounterKey, CounterValue> cache;
    private final FunctionalMap.ReadWriteMap<WeakCounterKey, CounterValue> readWriteMap;
    private final NotificationManager notificationManager;
    private final CounterConfiguration configuration;
    private volatile KeySelector selector;

    public WeakCounterImpl(String counterName, AdvancedCache<WeakCounterKey, CounterValue> cache, CounterConfiguration configuration) {
        this.cache = cache;
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(cache).withParams(new Param[]{Utils.getPersistenceMode(configuration.storage())});
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entries = WeakCounterImpl.initKeys(counterName, configuration.concurrencyLevel());
        this.selector = new KeySelector(this.entries);
        this.notificationManager = new NotificationManager();
        this.configuration = configuration;
    }

    private static <T> T get(int hash, T[] array) {
        return array[hash & array.length - 1];
    }

    private static Entry[] initKeys(String counterName, int concurrencyLevel) {
        ByteString name = ByteString.fromString((String)counterName);
        int size = Utils.nextPowerOfTwo(concurrencyLevel);
        Entry[] entries = new Entry[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = new Entry(new WeakCounterKey(name, i));
        }
        return entries;
    }

    public void init() {
        this.registerListener();
        this.initEntry(0, this.configuration);
        CounterConfiguration zeroConfig = CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(0L).storage(this.configuration.storage()).build();
        for (int i = 1; i < this.entries.length; ++i) {
            this.initEntry(i, zeroConfig);
        }
        this.selector.updatePreferredKeys(this.cache.getDistributionManager().getWriteConsistentHash());
    }

    private void initEntry(int index, CounterConfiguration configuration) {
        try {
            CounterValue existing = (CounterValue)this.readWriteMap.eval((Object)this.entries[index].key, new InitializeCounterFunction(configuration)).get();
            this.entries[index].init(existing);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CounterException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Utils.rethrowAsCounterException(e);
        }
    }

    public String getName() {
        return this.entries[0].key.getCounterName().toString();
    }

    public long getValue() {
        return this.getCachedValue();
    }

    public CompletableFuture<Void> add(long delta) {
        return this.readWriteMap.eval((Object)this.findKey(), new AddFunction(delta)).thenApply(this::handleAddResult);
    }

    public CompletableFuture<Void> reset() {
        int size = this.entries.length;
        CompletableFuture[] futures = new CompletableFuture[size];
        futures[0] = this.readWriteMap.eval((Object)this.entries[0].key, ResetFunction.getInstance());
        for (int i = 1; i < size; ++i) {
            futures[i] = this.readWriteMap.eval((Object)this.entries[i].key, ResetFunction.getInstance());
        }
        return CompletableFuture.allOf(futures);
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.addListener(listener);
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    @CacheEntryModified
    public void updateState(CacheEntryEvent<WeakCounterKey, CounterValue> event) {
        int index = ((WeakCounterKey)event.getKey()).getIndex();
        long base = this.getCachedValue(index);
        CounterValue snapshot = (CounterValue)event.getValue();
        CounterValue old = this.updateCounterState(index, snapshot);
        this.notificationManager.notify(CounterEventImpl.create(base + old.getValue(), base + snapshot.getValue()));
    }

    public WeakCounterKey[] getPreferredKeys() {
        return this.selector.preferredKeys;
    }

    public WeakCounterKey[] getKeys() {
        WeakCounterKey[] keys = new WeakCounterKey[this.entries.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.entries[i].key;
        }
        return keys;
    }

    private long getCachedValue() {
        long value = 0L;
        for (Entry e : this.entries) {
            long toAdd = e.snapshot.getValue();
            try {
                value = Math.addExact(value, toAdd);
            }
            catch (ArithmeticException ex) {
                return toAdd > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
        }
        return value;
    }

    private long getCachedValue(int skipIndex) {
        long value = 0L;
        for (int i = 0; i < this.entries.length; ++i) {
            if (i == skipIndex) continue;
            value += this.entries[i].snapshot.getValue();
        }
        return value;
    }

    private CounterValue updateCounterState(int index, CounterValue entry) {
        return this.entries[index].update(entry);
    }

    private Void handleAddResult(CounterValue counterValue) {
        if (counterValue == null) {
            throw new CompletionException((Throwable)log.counterDeleted());
        }
        return null;
    }

    private void registerListener() {
        CounterFilterAndConvert filter = new CounterFilterAndConvert(this.entries[0].key.getCounterName());
        this.cache.addListener((Object)this, filter, filter);
        this.cache.addListener((Object)this.selector);
    }

    private WeakCounterKey findKey() {
        return this.selector.findKey((int)Thread.currentThread().getId());
    }

    public String toString() {
        return "UnboundedStrongCounter{counterName=" + this.entries[0].key.getCounterName() + '}';
    }

    @Listener(sync=false)
    private class KeySelector {
        private final Entry[] entries;
        private volatile WeakCounterKey[] preferredKeys;

        private KeySelector(Entry[] entries) {
            this.entries = entries;
        }

        private WeakCounterKey findKey(int hash) {
            Object[] copy = this.preferredKeys;
            if (copy == null) {
                return ((Entry)WeakCounterImpl.get((int)hash, (Object[])this.entries)).key;
            }
            if (copy.length == 1) {
                return copy[0];
            }
            return (WeakCounterKey)WeakCounterImpl.get(hash, copy);
        }

        private void updatePreferredKeys(ConsistentHash consistentHash) {
            ArrayList<WeakCounterKey> preferredKeys = new ArrayList<WeakCounterKey>(this.entries.length);
            Address localNode = WeakCounterImpl.this.cache.getRpcManager().getAddress();
            for (Entry entry : this.entries) {
                if (!localNode.equals(consistentHash.locatePrimaryOwner((Object)entry.key))) continue;
                preferredKeys.add(entry.key);
            }
            this.preferredKeys = preferredKeys.isEmpty() ? null : preferredKeys.toArray(new WeakCounterKey[preferredKeys.size()]);
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent<WeakCounterKey, CounterValue> event) {
            this.updatePreferredKeys(event.getConsistentHashAtEnd());
        }
    }

    private static class Entry {
        public final WeakCounterKey key;
        volatile CounterValue snapshot = null;

        private Entry(WeakCounterKey key) {
            this.key = key;
        }

        private void init(CounterValue entry) {
            L1_UPDATER.compareAndSet(this, null, entry);
        }

        private CounterValue update(CounterValue entry) {
            return L1_UPDATER.getAndSet(this, entry);
        }
    }
}

