/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.impl.BaseCounterTest;
import org.infinispan.counter.util.TestCounter;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"})
public abstract class AbstractCounterTest<T extends TestCounter>
extends BaseCounterTest {
    public void testDiffInitValues(Method method) throws ExecutionException, InterruptedException {
        int i;
        TestContext context = new TestContext();
        String counterName = method.getName();
        long initialValue = 0L;
        context.printSeed(counterName);
        ArrayList counters = new ArrayList(this.clusterSize());
        for (i = 0; i < this.clusterSize(); ++i) {
            long rndLong = context.random.nextLong();
            if (i == 0) {
                initialValue = rndLong;
            }
            this.log.debug((Object)context.message("StrongCounter #%d initial value is %d", i, rndLong));
            counters.add(this.createCounter(this.counterManager(i), counterName, rndLong));
        }
        for (i = 0; i < this.clusterSize(); ++i) {
            int index = i;
            this.eventuallyEquals(context.message("Wrong initial value for counter #%d", i), initialValue, () -> ((TestCounter)counters.get(index)).getValue());
        }
    }

    public void testReset(Method method) throws ExecutionException, InterruptedException {
        int index;
        long delta;
        int i;
        String counterName = method.getName();
        TestContext context = new TestContext();
        context.printSeed(counterName);
        long initialValue = context.random.nextLong();
        ArrayList counters = new ArrayList(this.clusterSize());
        for (i = 0; i < this.clusterSize(); ++i) {
            counters.add(this.createCounter(this.counterManager(i), counterName, initialValue));
        }
        for (i = 0; i < this.clusterSize(); ++i) {
            delta = context.random.nextLong();
            this.addIgnoringBounds((TestCounter)counters.get(i), delta);
            this.log.debug((Object)context.message("StrongCounter #%d, Add %d", i, delta));
            ((TestCounter)counters.get(i)).reset();
            index = i;
            this.eventuallyEquals(context.message("Wrong initial value for counter #%d", i), initialValue, () -> ((TestCounter)counters.get(index)).getValue());
        }
        for (i = 0; i < this.clusterSize(); ++i) {
            delta = context.random.nextLong();
            this.addIgnoringBounds((TestCounter)counters.get(i), delta);
            this.log.debug((Object)context.message("StrongCounter #%d, Add %d", i, delta));
            ((TestCounter)counters.get(0)).reset();
            index = i;
            this.eventuallyEquals(context.message("Wrong initial value for counter #%d", i), initialValue, () -> ((TestCounter)counters.get(index)).getValue());
        }
    }

    public void testMaxAndMinLong(Method method) throws ExecutionException, InterruptedException {
        String counterName = method.getName();
        T counter = this.createCounter(this.counterManager(0), counterName, 0L);
        this.addAndAssertResult(counter, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        this.addAndAssertResult(counter, 1L, Long.MAX_VALUE);
        this.assertMaxValueAfterMaxValue(counter, 1L);
        this.assertMaxValueAfterMaxValue(counter, 1000L);
        this.addAndAssertResult(counter, -1L, 0x7FFFFFFFFFFFFFFEL);
        counter.reset();
        this.addAndAssertResult(counter, -9223372036854775807L, -9223372036854775807L);
        this.addAndAssertResult(counter, -1L, Long.MIN_VALUE);
        this.assertMinValueAfterMinValue(counter, -1L);
        this.assertMinValueAfterMinValue(counter, -1000L);
        this.addAndAssertResult(counter, 1L, -9223372036854775807L);
    }

    protected abstract void assertMinValueAfterMinValue(T var1, long var2);

    protected abstract T createCounter(CounterManager var1, String var2, long var3);

    protected abstract void assertMaxValueAfterMaxValue(T var1, long var2);

    protected abstract void addAndAssertResult(T var1, long var2, long var4);

    private void addIgnoringBounds(T counter, long delta) {
        try {
            counter.add(delta);
        }
        catch (CounterOutOfBoundsException e) {
            this.log.debug((Object)"ignored.", (Throwable)e);
        }
    }

    class TestContext {
        final Random random;
        private final long seed;

        TestContext() {
            this(System.nanoTime());
        }

        private TestContext(long seed) {
            this.seed = seed;
            this.random = new Random(seed);
        }

        void printSeed(String testName) {
            AbstractCounterTest.this.log.infof("Test '%s' seed is %d", (Object)testName, (Object)this.seed);
        }

        String message(String format, Object ... args) {
            return "[seed=" + this.seed + "] " + String.format(format, args);
        }
    }
}

