/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.util.concurrent.ExecutionException;
import org.infinispan.counter.AbstractCounterTest;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.util.WeakTestCounter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.WeakCounterTest")
public class WeakCounterTest
extends AbstractCounterTest<WeakTestCounter> {
    private static final int CLUSTER_SIZE = 4;

    public void testSingleConcurrencyLevel() throws ExecutionException, InterruptedException {
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.manager(0));
        String counterName = "c1-counter";
        counterManager.defineCounter("c1-counter", CounterConfiguration.builder((CounterType)CounterType.WEAK).concurrencyLevel(1).build());
        WeakCounter wc = counterManager.getWeakCounter("c1-counter");
        wc.add(2L).get();
        AssertJUnit.assertEquals((long)2L, (long)wc.getValue());
    }

    @Override
    protected void assertMaxValueAfterMaxValue(WeakTestCounter counter, long delta) {
        counter.add(delta);
        this.eventuallyEquals(Long.MAX_VALUE, counter::getValue);
    }

    @Override
    protected void addAndAssertResult(WeakTestCounter counter, long delta, long expected) {
        counter.add(delta);
        this.eventuallyEquals(expected, counter::getValue);
    }

    @Override
    protected void assertMinValueAfterMinValue(WeakTestCounter counter, long delta) {
        counter.add(delta);
        this.eventuallyEquals(Long.MIN_VALUE, counter::getValue);
    }

    @Override
    protected int clusterSize() {
        return 4;
    }

    @Override
    protected WeakTestCounter createCounter(CounterManager counterManager, String counterName, long initialValue) {
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(initialValue).concurrencyLevel(4).build());
        return new WeakTestCounter(counterManager.getWeakCounter(counterName));
    }
}

