/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.infinispan.counter.StrongCounterTest;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.util.StrongTestCounter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.BoundedCounterTest")
public class BoundedCounterTest
extends StrongCounterTest {
    public void testSimpleThreshold(Method method) throws ExecutionException, InterruptedException {
        CounterManager counterManager = this.counterManager(0);
        counterManager.defineCounter(method.getName(), CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(-1L).upperBound(1L).build());
        StrongTestCounter counter = new StrongTestCounter(counterManager.getStrongCounter(method.getName()));
        this.addAndAssertResult(counter, 1L, 1L);
        this.assertOutOfBoundsAdd(counter, 1L, 1L);
        this.addAndAssertResult(counter, -1L, 0L);
        this.addAndAssertResult(counter, -1L, -1L);
        this.assertOutOfBoundsAdd(counter, -1L, -1L);
        counter.reset();
        this.assertOutOfBoundsAdd(counter, 2L, 1L);
        this.assertOutOfBoundsAdd(counter, -3L, -1L);
    }

    public void testCompareAndSetBounds(Method method) {
        CounterManager counterManager = this.counterManager(0);
        counterManager.defineCounter(method.getName(), CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(-2L).upperBound(2L).build());
        SyncStrongCounter counter = counterManager.getStrongCounter(method.getName()).sync();
        AssertJUnit.assertTrue((boolean)counter.compareAndSet(0L, 2L));
        AssertJUnit.assertEquals((long)2L, (long)counter.getValue());
        this.assertOutOfBoundCompareAndSet(counter, 2L, 3L);
        counter.reset();
        AssertJUnit.assertTrue((boolean)counter.compareAndSet(0L, -2L));
        AssertJUnit.assertEquals((long)-2L, (long)counter.getValue());
        this.assertOutOfBoundCompareAndSet(counter, -2L, -3L);
        counter.reset();
        AssertJUnit.assertFalse((boolean)counter.compareAndSet(1L, 3L));
        AssertJUnit.assertFalse((boolean)counter.compareAndSet(1L, -3L));
    }

    public void testCompareAndSwapBounds(Method method) {
        CounterManager counterManager = this.counterManager(0);
        counterManager.defineCounter(method.getName(), CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(-2L).upperBound(2L).build());
        SyncStrongCounter counter = counterManager.getStrongCounter(method.getName()).sync();
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(0L, 2L));
        AssertJUnit.assertEquals((long)2L, (long)counter.getValue());
        this.assertOutOfBoundCompareAndSwap(counter, 2L, 3L);
        counter.reset();
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(0L, -2L));
        AssertJUnit.assertEquals((long)-2L, (long)counter.getValue());
        this.assertOutOfBoundCompareAndSwap(counter, -2L, -3L);
        counter.reset();
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(1L, 3L));
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(1L, -3L));
    }

    @Override
    protected StrongTestCounter createCounter(CounterManager counterManager, String counterName, long initialValue) {
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(Long.MIN_VALUE).upperBound(Long.MAX_VALUE).initialValue(initialValue).build());
        return new StrongTestCounter(counterManager.getStrongCounter(counterName));
    }

    @Override
    protected void assertMaxValueAfterMaxValue(StrongTestCounter counter, long delta) {
        this.assertOutOfBoundsAdd(counter, delta, Long.MAX_VALUE);
    }

    @Override
    protected void assertMinValueAfterMinValue(StrongTestCounter counter, long delta) {
        this.assertOutOfBoundsAdd(counter, delta, Long.MIN_VALUE);
    }

    @Override
    protected List<CounterConfiguration> configurationToTest() {
        return Arrays.asList(CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(10L).lowerBound(1L).build(), CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(-10L).upperBound(1L).build(), CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(1L).upperBound(2L).upperBound(2L).build(), CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).build());
    }

    private void assertOutOfBoundsAdd(StrongTestCounter counter, long delta, long expected) {
        try {
            counter.add(delta);
            AssertJUnit.fail((String)"Bound should have been reached!");
        }
        catch (CounterOutOfBoundsException e) {
            this.log.debug((Object)"Expected exception.", (Throwable)e);
        }
        AssertJUnit.assertEquals((String)"Wrong return value of counter.getNewValue()", (long)expected, (long)counter.getValue());
    }

    private void assertOutOfBoundCompareAndSet(SyncStrongCounter counter, long expect, long value) {
        try {
            counter.compareAndSet(expect, value);
            AssertJUnit.fail((String)"Threshold should have been reached!");
        }
        catch (CounterOutOfBoundsException e) {
            this.log.debug((Object)"Expected exception", (Throwable)e);
        }
        AssertJUnit.assertEquals((String)"Wrong return value of counter.getNewValue()", (long)expect, (long)counter.getValue());
    }

    private void assertOutOfBoundCompareAndSwap(SyncStrongCounter counter, long expect, long value) {
        try {
            counter.compareAndSwap(expect, value);
            AssertJUnit.fail((String)"Threshold should have been reached!");
        }
        catch (CounterOutOfBoundsException e) {
            this.log.debug((Object)"Expected exception", (Throwable)e);
        }
        AssertJUnit.assertEquals((String)"Wrong return value of counter.getNewValue()", (long)expect, (long)counter.getValue());
    }
}

