/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.infinispan.counter.AbstractCounterTest;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.util.StrongTestCounter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.StrongCounterTest")
public class StrongCounterTest
extends AbstractCounterTest<StrongTestCounter> {
    private static final int CLUSTER_SIZE = 4;

    public void testUniqueReturnValues(Method method) throws ExecutionException, InterruptedException, TimeoutException {
        int numThreadsPerNode = this.clusterSize() == 1 ? 8 : 2;
        int totalThreads = this.clusterSize() * numThreadsPerNode;
        ArrayList<Future> workers = new ArrayList<Future>(totalThreads);
        String counterName = method.getName();
        CyclicBarrier barrier = new CyclicBarrier(totalThreads);
        long counterLimit = 1000L;
        for (int i = 0; i < totalThreads; ++i) {
            int cmIndex = i % this.clusterSize();
            workers.add(this.fork(() -> {
                LinkedList<Long> retValues = new LinkedList<Long>();
                CounterManager manager = this.counterManager(cmIndex);
                StrongTestCounter counter = this.createCounter(manager, counterName, 0L);
                long lastRet = 0L;
                barrier.await();
                while (lastRet < 1000L) {
                    lastRet = counter.addAndGet(1L);
                    retValues.add(lastRet);
                }
                return retValues;
            }));
        }
        HashSet<Long> uniqueValuesCheck = new HashSet<Long>();
        for (Future w : workers) {
            List returnValues = (List)w.get(1L, TimeUnit.MINUTES);
            for (Long l : returnValues) {
                AssertJUnit.assertTrue((String)String.format("Duplicated value %d", l), (boolean)uniqueValuesCheck.add(l));
            }
        }
        for (long l = 1L; l < 1003L; ++l) {
            AssertJUnit.assertTrue((String)String.format("Value %d does not exists!", l), (boolean)uniqueValuesCheck.contains(l));
        }
    }

    public void testCompareAndSet(Method method) {
        int i;
        String counterName = method.getName();
        AbstractCounterTest.TestContext context = new AbstractCounterTest.TestContext();
        context.printSeed(counterName);
        long expect = context.random.nextLong();
        long value = context.random.nextLong();
        StrongTestCounter counter = this.createCounter(this.counterManager(0), counterName, expect);
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertTrue((boolean)counter.compareAndSet(expect, value));
            AssertJUnit.assertEquals((long)value, (long)counter.getValue());
            expect = value;
            value = context.random.nextLong();
        }
        for (i = 0; i < 10; ++i) {
            long notExpected = context.random.nextLong();
            while (expect == notExpected) {
                notExpected = context.random.nextLong();
            }
            AssertJUnit.assertFalse((boolean)counter.compareAndSet(notExpected, value));
            AssertJUnit.assertEquals((long)expect, (long)counter.getValue());
        }
    }

    public void testCompareAndSwap(Method method) {
        int i;
        String counterName = method.getName();
        AbstractCounterTest.TestContext context = new AbstractCounterTest.TestContext();
        context.printSeed(counterName);
        long expect = context.random.nextLong();
        long value = context.random.nextLong();
        StrongTestCounter counter = this.createCounter(this.counterManager(0), counterName, expect);
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertEquals((long)expect, (long)counter.compareAndSwap(expect, value));
            AssertJUnit.assertEquals((long)value, (long)counter.getValue());
            expect = value;
            value = context.random.nextLong();
        }
        for (i = 0; i < 10; ++i) {
            long notExpected = context.random.nextLong();
            while (expect == notExpected) {
                notExpected = context.random.nextLong();
            }
            AssertJUnit.assertEquals((long)expect, (long)counter.compareAndSwap(notExpected, value));
            AssertJUnit.assertEquals((long)expect, (long)counter.getValue());
        }
    }

    @Test(groups={"unstable"}, description="ISPN-8786")
    public void testCompareAndSetConcurrent(Method method) throws ExecutionException, InterruptedException, TimeoutException {
        int numThreadsPerNode = this.clusterSize() == 1 ? 8 : 2;
        int totalThreads = this.clusterSize() * numThreadsPerNode;
        ArrayList<Future> workers = new ArrayList<Future>(totalThreads);
        String counterName = method.getName();
        CyclicBarrier barrier = new CyclicBarrier(totalThreads);
        AtomicIntegerArray retValues = new AtomicIntegerArray(totalThreads);
        long maxIterations = 100L;
        for (int i = 0; i < totalThreads; ++i) {
            int threadIndex = i;
            int cmIndex = i % this.clusterSize();
            workers.add(this.fork(() -> {
                long initialValue = 0L;
                long previousValue = 0L;
                CounterManager manager = this.counterManager(cmIndex);
                StrongTestCounter counter = this.createCounter(manager, counterName, 0L);
                for (long iteration = 0L; iteration < 100L; ++iteration) {
                    AssertJUnit.assertEquals((long)previousValue, (long)counter.getValue());
                    long update = previousValue + 1L;
                    barrier.await();
                    boolean ret = counter.compareAndSet(previousValue, update);
                    previousValue = ret ? update : counter.getValue();
                    retValues.set(threadIndex, ret ? 1 : 0);
                    barrier.await();
                    this.assertUnique(retValues, iteration);
                }
                return true;
            }));
        }
        for (Future w : workers) {
            w.get(1L, TimeUnit.MINUTES);
        }
    }

    public void testCompareAndSwapConcurrent(Method method) throws ExecutionException, InterruptedException, TimeoutException {
        int numThreadsPerNode = this.clusterSize() == 1 ? 8 : 2;
        int totalThreads = this.clusterSize() * numThreadsPerNode;
        ArrayList<Future> workers = new ArrayList<Future>(totalThreads);
        String counterName = method.getName();
        CyclicBarrier barrier = new CyclicBarrier(totalThreads);
        AtomicIntegerArray retValues = new AtomicIntegerArray(totalThreads);
        long maxIterations = 100L;
        for (int i = 0; i < totalThreads; ++i) {
            int threadIndex = i;
            int cmIndex = i % this.clusterSize();
            workers.add(this.fork(() -> {
                long initialValue = 0L;
                long previousValue = 0L;
                CounterManager manager = this.counterManager(cmIndex);
                StrongTestCounter counter = this.createCounter(manager, counterName, 0L);
                for (long iteration = 0L; iteration < 100L; ++iteration) {
                    AssertJUnit.assertEquals((long)previousValue, (long)counter.getValue());
                    long update = previousValue + 1L;
                    barrier.await();
                    long ret = counter.compareAndSwap(previousValue, update);
                    boolean success = ret == previousValue;
                    previousValue = success ? update : ret;
                    retValues.set(threadIndex, success ? 1 : 0);
                    barrier.await();
                    this.assertUnique(retValues, iteration);
                }
                return true;
            }));
        }
        for (Future w : workers) {
            w.get(1L, TimeUnit.MINUTES);
        }
    }

    public void testCompareAndSetMaxAndMinLong(Method method) {
        String counterName = method.getName();
        StrongTestCounter counter = this.createCounter(this.counterManager(0), counterName, 0L);
        AssertJUnit.assertFalse((boolean)counter.compareAndSet(-1L, Long.MAX_VALUE));
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
        AssertJUnit.assertTrue((boolean)counter.compareAndSet(0L, Long.MAX_VALUE));
        AssertJUnit.assertEquals((long)Long.MAX_VALUE, (long)counter.getValue());
        counter.reset();
        AssertJUnit.assertFalse((boolean)counter.compareAndSet(-1L, Long.MIN_VALUE));
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
        AssertJUnit.assertTrue((boolean)counter.compareAndSet(0L, Long.MIN_VALUE));
        AssertJUnit.assertEquals((long)Long.MIN_VALUE, (long)counter.getValue());
    }

    public void testCompareAndSwapMaxAndMinLong(Method method) {
        String counterName = method.getName();
        StrongTestCounter counter = this.createCounter(this.counterManager(0), counterName, 0L);
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(-1L, Long.MAX_VALUE));
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(0L, Long.MAX_VALUE));
        AssertJUnit.assertEquals((long)Long.MAX_VALUE, (long)counter.getValue());
        counter.reset();
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(-1L, Long.MIN_VALUE));
        AssertJUnit.assertEquals((long)0L, (long)counter.getValue());
        AssertJUnit.assertEquals((long)0L, (long)counter.compareAndSwap(0L, Long.MIN_VALUE));
        AssertJUnit.assertEquals((long)Long.MIN_VALUE, (long)counter.getValue());
    }

    @Override
    protected StrongTestCounter createCounter(CounterManager counterManager, String counterName, long initialValue) {
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(initialValue).build());
        return new StrongTestCounter(counterManager.getStrongCounter(counterName));
    }

    @Override
    protected void assertMaxValueAfterMaxValue(StrongTestCounter counter, long delta) {
        AssertJUnit.assertEquals((long)Long.MAX_VALUE, (long)counter.addAndGet(delta));
        AssertJUnit.assertEquals((long)Long.MAX_VALUE, (long)counter.getValue());
    }

    @Override
    protected void addAndAssertResult(StrongTestCounter counter, long delta, long expected) {
        AssertJUnit.assertEquals((String)String.format("Wrong return value after adding %d", delta), (long)expected, (long)counter.addAndGet(delta));
        AssertJUnit.assertEquals((String)"Wrong return value of counter.getNewValue()", (long)expected, (long)counter.getValue());
    }

    @Override
    protected StrongTestCounter createCounter(CounterManager counterManager, String counterName, CounterConfiguration configuration) {
        counterManager.defineCounter(counterName, configuration);
        return new StrongTestCounter(counterManager.getStrongCounter(counterName));
    }

    @Override
    protected List<CounterConfiguration> configurationToTest() {
        return Arrays.asList(CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(10L).build(), CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(20L).build(), CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
    }

    @Override
    protected void assertMinValueAfterMinValue(StrongTestCounter counter, long delta) {
        AssertJUnit.assertEquals((long)Long.MIN_VALUE, (long)counter.addAndGet(delta));
        AssertJUnit.assertEquals((long)Long.MIN_VALUE, (long)counter.getValue());
    }

    @Override
    protected int clusterSize() {
        return 4;
    }

    private void assertUnique(AtomicIntegerArray retValues, long it) {
        int successCount = 0;
        for (int ix = 0; ix != retValues.length(); ++ix) {
            successCount += retValues.get(ix);
        }
        AssertJUnit.assertEquals((String)("Multiple threads succeeded with update in iteration " + it), (int)1, (int)successCount);
    }
}

